/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.swing.JComponentPanelHolder;
import org.jdal.swing.PanelHolder;
import org.jdal.swing.View;
import org.jdal.swing.ViewPanelHolder;
import org.jdal.swing.form.FormUtils;
import org.jdal.swing.list.ListListModel;

public class ListPane
extends JPanel
implements ListSelectionListener {
    public static final String DEFAULT_TABLE_ICON = "/images/table/table.png";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ListPane.class);
    private List<PanelHolder> panels = new ArrayList<PanelHolder>();
    private JList list;
    private Icon tableIcon;
    private JPanel editorPanel = new JPanel(new BorderLayout());
    private JSplitPane split;
    private ListCellRenderer renderer = new ListCellRenderer();
    private List<ListSelectionListener> listeners = new ArrayList<ListSelectionListener>();
    private int cellHeight = 0;

    public void init() {
        this.setLayout(new BoxLayout(this, 2));
        this.tableIcon = FormUtils.getIcon(this.tableIcon, DEFAULT_TABLE_ICON);
        for (PanelHolder p : this.panels) {
            p.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        }
        this.list = new JList<PanelHolder>(new ListListModel<PanelHolder>(this.panels));
        this.list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(-1);
        this.list.addListSelectionListener(this);
        this.list.setCellRenderer(this.renderer);
        this.list.setSelectedIndex(0);
        if (this.cellHeight != 0) {
            this.list.setFixedCellHeight(this.cellHeight);
        }
        JScrollPane scroll = new JScrollPane(this.list);
        this.split = new JSplitPane(1, scroll, this.editorPanel);
        this.split.setResizeWeight(0.0);
        this.split.setDividerLocation(150);
        this.add(this.split);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PanelHolder panel = (PanelHolder)this.list.getSelectedValue();
        this.editorPanel.removeAll();
        this.editorPanel.add(panel.getPanel());
        this.editorPanel.revalidate();
        this.editorPanel.repaint();
        this.fireValueChanged(e);
    }

    private void fireValueChanged(ListSelectionEvent e) {
        for (ListSelectionListener lsl : this.listeners) {
            lsl.valueChanged(e);
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.listeners.remove(l);
    }

    public Icon getTableIcon() {
        return this.tableIcon;
    }

    public void setTableIcon(Icon tableIcon) {
        this.tableIcon = tableIcon;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
    }

    public List<PanelHolder> getPanels() {
        return this.panels;
    }

    public void setPanels(List<PanelHolder> panels) {
        this.panels = panels;
    }

    public void addPanel(Object panel, String name, Icon icon) {
        PanelHolder holder = null;
        if (panel instanceof View) {
            holder = new ViewPanelHolder((View)panel);
        } else if (panel instanceof JComponent) {
            holder = new JComponentPanelHolder((JComponent)panel);
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Try to add unsupported object type [" + panel.getClass().getName()));
            }
            return;
        }
        holder.setIcon(icon);
        holder.setName(name);
        this.panels.add(holder);
    }

    class ListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        ListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PanelHolder panel = (PanelHolder)value;
            this.setText(panel.getName());
            Icon icon = panel.getIcon() != null ? panel.getIcon() : ListPane.this.tableIcon;
            this.setIcon(icon);
            return this;
        }
    }
}

