/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.swing;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdal.model.Attachment;
import org.jdal.swing.AbstractView;
import org.jdal.swing.form.BoxFormBuilder;
import org.jdal.swing.form.FormUtils;
import org.jdal.swing.list.ListListModel;
import org.jdal.system.SystemUtils;

public class AttachmentView
extends AbstractView<List<Attachment>> {
    private static final String DEFAULT_ADD_ICON = "org/freedesktop/tango/16x16/actions/list-add.png";
    private static final String DEFAULT_REMOVE_ICON = "org/freedesktop/tango/16x16/actions/list-remove.png";
    private JList attachments = new JList(new ListListModel());
    private Icon addIcon;
    private Icon removeIcon;
    private ListCellRenderer listCellRenderer;

    public AttachmentView() {
        this(new ArrayList<Attachment>());
    }

    public AttachmentView(ArrayList<Attachment> attachments) {
        this.setModel(attachments);
    }

    public void init() {
        this.addIcon = FormUtils.getIcon(this.addIcon, DEFAULT_ADD_ICON);
        this.removeIcon = FormUtils.getIcon(this.removeIcon, DEFAULT_REMOVE_ICON);
    }

    @Override
    protected JComponent buildPanel() {
        JScrollPane scroll = new JScrollPane(this.attachments);
        this.attachments.setCellRenderer(this.listCellRenderer);
        this.attachments.addMouseListener(new AttachmentMouseListener());
        BoxFormBuilder fb = new BoxFormBuilder();
        fb.row();
        fb.startBox();
        fb.setFixedHeight(true);
        fb.row();
        fb.add(new JButton(new AddAction()));
        fb.setMaxWidth(25);
        fb.add(new JButton(new RemoveAction()));
        fb.setMaxWidth(25);
        fb.endBox();
        fb.row(Short.MAX_VALUE);
        fb.add(scroll);
        return fb.getForm();
    }

    private void addAttachment() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(this.getPanel()) == 0) {
            File[] files = chooser.getSelectedFiles();
            ArrayList<Attachment> addList = new ArrayList<Attachment>(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    addList.add(new Attachment(file));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.getPanel(), String.valueOf(this.getMessage("AttachmentView.cantReadFile")) + " " + file.getName());
                }
                ++n2;
            }
            ListListModel listModel = (ListListModel)this.attachments.getModel();
            listModel.addAll(addList);
        }
    }

    private void removeAttachment() {
        Object[] values = this.attachments.getSelectedValues();
        ListListModel listModel = (ListListModel)this.attachments.getModel();
        listModel.removeAll(Arrays.asList(values));
    }

    protected void doRefresh() {
        ListListModel llm = (ListListModel)this.attachments.getModel();
        llm.clear();
        llm.addAll((Collection)this.getModel());
    }

    protected void doUpdate() {
        ((List)this.getModel()).clear();
        ListListModel llm = (ListListModel)this.attachments.getModel();
        ((List)this.getModel()).addAll(llm.getList());
    }

    public Icon getAddIcon() {
        return this.addIcon;
    }

    public void setAddIcon(Icon addIcon) {
        this.addIcon = addIcon;
    }

    public Icon getRemoveIcon() {
        return this.removeIcon;
    }

    public void setRemoveIcon(Icon removeIcon) {
        this.removeIcon = removeIcon;
    }

    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this.listCellRenderer = listCellRenderer;
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("SmallIcon", AttachmentView.this.addIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttachmentView.this.addAttachment();
        }
    }

    private class AttachmentMouseListener
    extends MouseAdapter {
        private AttachmentMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int index = AttachmentView.this.attachments.locationToIndex(e.getPoint());
                ListModel dlm = AttachmentView.this.attachments.getModel();
                Attachment a = (Attachment)dlm.getElementAt(index);
                AttachmentView.this.attachments.ensureIndexIsVisible(index);
                SystemUtils.open((byte[])a.getData(), (String)a.getName());
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("SmallIcon", AttachmentView.this.removeIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttachmentView.this.removeAttachment();
        }
    }
}

