/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdal.db.DbConnection;
import org.jdal.db.DbConnectionForm;
import org.jdal.swing.ViewDialog;

public class DatabaseManager {
    private static final Log log = LogFactory.getLog(DatabaseManager.class);
    private String applicationName;

    public DatabaseManager(String applicationName) {
        this.applicationName = applicationName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DbConnection getDbConnection(String path) {
        File properties = new File(path);
        Properties prop = new Properties();
        DbConnection conn = new DbConnection();
        try {
            if (!properties.exists() && !properties.createNewFile()) {
                return null;
            }
            prop.load(new FileInputStream(properties));
            conn.fromProperties(prop);
            if (conn.test()) {
                return conn;
            }
            do {
                if (!this.askToCreateConnection()) return null;
                if (this.createConnection(conn) != null) continue;
                return null;
            } while (!conn.test());
            prop = conn.toProperties();
            prop.store(new FileOutputStream(properties), "");
            return conn;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return null;
    }

    public DbConnection createConnection() {
        return this.createConnection(new DbConnection());
    }

    public DbConnection createConnection(DbConnection conn) {
        DbConnectionForm dbf = new DbConnectionForm(conn);
        dbf.init();
        ViewDialog<DbConnection> dlg = new ViewDialog<DbConnection>();
        dlg.setView(dbf);
        dlg.init();
        dlg.setSize(500, 400);
        dlg.setModal(true);
        dlg.setVisible(true);
        if (dlg.getValue() != 0) {
            return null;
        }
        return (DbConnection)dlg.getModel();
    }

    public boolean askToCreateConnection() {
        return JOptionPane.showConfirmDialog(null, "There isn't a database connection configured for " + this.applicationName + "\nor configuration is not working.\nDo you want to create one now ?") == 0;
    }
}

