/*
 * Decompiled with CFR 0.152.
 */
package org.jdal.beans;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdal.swing.ListTableModel;
import org.jdal.swing.PageableTable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TableBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ENTITY = "entity";
    private static final String ID = "id";
    private static final String TABLE_PANEL_SUFFIX = "Table";
    private static final String TABLE_PANEL_CLASS = "table-panel-class";
    private static final String LIST_TABLE_MODEL_SUFFIX = "TableModel";
    private static final String PAGEABLE_TABLE_SUFFIX = "PageableTable";
    private static final String SERVICE_SUFFIX = "Service";
    private static final String EDITOR_SUFFIX = "Editor";
    private static final String EDITOR = "editor";
    private static final String EDITOR_NAME = "editorName";
    private static final String DATA_SOURCE = "dataSource";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String PAGINATOR_VIEW = "paginatorView";
    private static final String PAGINATOR = "paginator";
    private static final String TABLE_MODEL = "tableModel";
    private static final String TABLE = "table";
    private static final String COLUMNS = "columns";
    private static final String ACTIONS = "actions";
    private static final String USE_ACTIONS = "use-actions";
    private static final String GUI_FACTORY = "guiFactory";
    private static final String PERSISTENT_SERVICE = "persistentService";
    private static final String FILTER = "filter";
    private static final String FILTER_VIEW = "filter-view";
    private static final String TABLE_SERVICE = "table-service";
    private static final String NAME = "name";
    private static final String SHOW_MENU = "show-menu";
    private static final String MESSAGE_SOURCE = "messageSource";
    private static final String SCOPE = "scope";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String entity = null;
        if (element.hasAttribute(ENTITY)) {
            entity = element.getAttribute(ENTITY);
        }
        String name = StringUtils.uncapitalize((String)StringUtils.substringAfterLast(entity, (String)"."));
        if (element.hasAttribute(ID)) {
            name = element.getAttribute(ID);
        }
        parserContext.pushContainingComponent(new CompositeComponentDefinition(name, parserContext.extractSource((Object)element)));
        String tableModelBeanName = String.valueOf(name) + LIST_TABLE_MODEL_SUFFIX;
        String tablePanelBeanName = String.valueOf(name) + TABLE_PANEL_SUFFIX;
        String pageableTableBeanName = String.valueOf(name) + PAGEABLE_TABLE_SUFFIX;
        String dataSource = String.valueOf(name) + SERVICE_SUFFIX;
        String paginator = PAGINATOR_VIEW;
        String editor = String.valueOf(name) + EDITOR_SUFFIX;
        String actions = "defaultTableActions";
        String guiFactory = "defaultGuiFactory";
        String scope = "prototype";
        if (element.hasAttribute(SERVICE_ATTRIBUTE)) {
            dataSource = element.getAttribute(SERVICE_ATTRIBUTE);
        }
        if (element.hasAttribute(PAGINATOR)) {
            paginator = element.getAttribute(PAGINATOR);
        }
        if (element.hasAttribute(ACTIONS)) {
            actions = element.getAttribute(ACTIONS);
        }
        if (element.hasAttribute(GUI_FACTORY)) {
            guiFactory = element.getAttribute(GUI_FACTORY);
        }
        if (element.hasAttribute(EDITOR)) {
            editor = element.getAttribute(EDITOR);
        }
        if (element.hasAttribute(SCOPE)) {
            scope = element.getAttribute(SCOPE);
        }
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.genericBeanDefinition(ListTableModel.class);
        bdb.setScope(scope);
        bdb.addPropertyValue("modelClass", (Object)entity);
        NodeList nl = element.getElementsByTagNameNS(element.getNamespaceURI(), COLUMNS);
        if (nl.getLength() > 0) {
            List columns = parserContext.getDelegate().parseListElement((Element)nl.item(0), (BeanDefinition)bdb.getRawBeanDefinition());
            bdb.addPropertyValue(COLUMNS, (Object)columns);
        }
        this.registerBeanDefinition(element, parserContext, tableModelBeanName, bdb);
        bdb = BeanDefinitionBuilder.genericBeanDefinition(PageableTable.class);
        bdb.setScope("prototype");
        bdb.addPropertyReference(DATA_SOURCE, dataSource);
        bdb.addPropertyReference(PAGINATOR_VIEW, paginator);
        bdb.addPropertyReference(TABLE_MODEL, tableModelBeanName);
        bdb.addPropertyValue(NAME, (Object)pageableTableBeanName);
        if (element.hasAttribute(TABLE_SERVICE)) {
            bdb.addPropertyReference(Conventions.attributeNameToPropertyName((String)TABLE_SERVICE), element.getAttribute(TABLE_SERVICE));
        }
        if (element.hasAttribute(FILTER)) {
            bdb.addPropertyReference(FILTER, element.getAttribute(FILTER));
        }
        if (element.hasAttribute(SHOW_MENU)) {
            bdb.addPropertyValue(Conventions.attributeNameToPropertyName((String)SHOW_MENU), (Object)element.getAttribute(SHOW_MENU));
        }
        if (element.hasAttribute(MESSAGE_SOURCE)) {
            bdb.addPropertyReference(MESSAGE_SOURCE, element.getAttribute(MESSAGE_SOURCE));
        }
        this.registerBeanDefinition(element, parserContext, pageableTableBeanName, bdb);
        String tablePanelClassName = "org.jdal.swing.table.TablePanel";
        if (element.hasAttribute(TABLE_PANEL_CLASS)) {
            tablePanelClassName = element.getAttribute(TABLE_PANEL_CLASS);
        }
        bdb = BeanDefinitionBuilder.genericBeanDefinition((String)tablePanelClassName);
        bdb.setScope("prototype");
        bdb.addPropertyReference(TABLE, pageableTableBeanName);
        bdb.addPropertyReference(GUI_FACTORY, guiFactory);
        bdb.addPropertyValue(EDITOR_NAME, (Object)editor);
        bdb.addPropertyReference(PERSISTENT_SERVICE, dataSource);
        if (element.hasAttribute(FILTER_VIEW)) {
            bdb.addPropertyReference(Conventions.attributeNameToPropertyName((String)FILTER_VIEW), element.getAttribute(FILTER_VIEW));
        }
        if (!element.hasAttribute(USE_ACTIONS) || "true".equals(element.getAttribute(USE_ACTIONS))) {
            bdb.addPropertyReference(ACTIONS, actions);
        }
        this.registerBeanDefinition(element, parserContext, tablePanelBeanName, bdb);
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void registerBeanDefinition(Element element, ParserContext parserContext, String beanName, BeanDefinitionBuilder bdb) {
        AbstractBeanDefinition bd = bdb.getBeanDefinition();
        parserContext.getDelegate().parseBeanDefinitionAttributes(element, beanName, null, bd);
        BeanComponentDefinition bcd = new BeanComponentDefinition((BeanDefinition)bdb.getBeanDefinition(), beanName);
        parserContext.registerBeanComponent(bcd);
    }
}

