/*
 * Copyright 2009-2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jdal.swing.bind;

import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jdal.ui.bind.AbstractControlAccessor;

/**
 * ControlAccessor for JToggleButton
 * 
 * @author Jose Luis Martin - (jlm@joseluismartin.info)
 * @since 1.1
 * @see org.jdal.ui.bind.ControlAccessor
 */
public class ToggleButtonAccessor extends AbstractControlAccessor implements ChangeListener
	{

	public ToggleButtonAccessor(Object button) {
		super(button);
		getControl().getModel().addChangeListener(this);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public Boolean getControlValue() {
		return getControl().isSelected();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setControlValue(Object value) {
		if (value == null)
			value = false;
		getControl().setSelected(convertIfNecessary(value, Boolean.class));
	}
	
	/**
	 * {@inheritDoc}
	 */
	public JToggleButton getControl() {
		return (JToggleButton) super.getControl();
	}

	/**
	 * {@inheritDoc}
	 */
	public void stateChanged(ChangeEvent e) {
		fireControlChange();
	}

}
