/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.tree;

import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.list.ListComboBoxModel;
import info.joseluismartin.gui.tree.TreeModelBuilder;
import info.joseluismartin.gui.tree.TreeViewModel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeView
extends AbstractView<TreeViewModel>
implements ActionListener {
    private JComboBox combo = FormUtils.newCombo(25);
    private JTree tree = new JTree();

    public void init() {
        this.combo.addActionListener(this);
    }

    @Override
    protected JComponent buildPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add("North", this.combo);
        p.add("Center", new JScrollPane(this.tree));
        return p;
    }

    @Override
    protected void doRefresh() {
        TreeViewModel model = (TreeViewModel)this.getModel();
        if (model != null) {
            this.combo.setModel(new ListComboBoxModel((List)model.getBuilders()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeModelBuilder b = (TreeModelBuilder)this.combo.getSelectedItem();
        if (b != null) {
            this.tree.setModel(b.build());
        }
    }
}

