/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.table;

import info.joseluismartin.dao.Page;
import info.joseluismartin.dao.PageableDataSource;
import info.joseluismartin.gui.EditorListener;
import info.joseluismartin.gui.GuiFactory;
import info.joseluismartin.gui.PageableTable;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.report.ReportListView;
import info.joseluismartin.gui.table.AddAction;
import info.joseluismartin.gui.table.TablePanelAction;
import info.joseluismartin.reporting.ReportDataProvider;
import info.joseluismartin.service.PersistentService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePanel<T>
extends JPanel
implements ReportDataProvider {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TablePanel.class);
    private GuiFactory guiFactory;
    private String name;
    private PageableTable<T> table;
    private View<Object> filterView;
    private ReportListView reportListView;
    private List<Action> actions = new ArrayList<Action>();
    private PropertyValues propertyValues;
    private Box controlBox;

    public TablePanel() {
        BorderLayout layout = new BorderLayout();
        layout.setVgap(10);
        layout.setHgap(10);
        this.setLayout(layout);
    }

    public void init() {
        this.add(this.createFilterBox(), "North");
        this.add(this.createTableBox(), "Center");
        if (this.filterView != null) {
            this.table.setFilter(this.filterView.getModel());
        }
        if (this.guiFactory != null) {
            this.table.setGuiFactory(this.guiFactory);
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F2"), "addAction");
        this.getActionMap().put("addAction", new AddAction());
    }

    private Component createReportListBox() {
        Box tableBox = Box.createHorizontalBox();
        tableBox.add(this.reportListView.getPanel());
        this.reportListView.setReportProvider(this);
        return tableBox;
    }

    private Component createTableBox() {
        Box tableBox = Box.createVerticalBox();
        tableBox.add(this.createControlBox());
        tableBox.add(Box.createVerticalStrut(5));
        this.table.setAlignmentX(0.0f);
        tableBox.add(this.table);
        return tableBox;
    }

    private Component createFilterBox() {
        Box header = Box.createVerticalBox();
        if (this.filterView != null) {
            header.add(Box.createVerticalStrut(10));
            this.filterView.refresh();
            header.add(this.filterView.getPanel());
        }
        header.setAlignmentX(0.0f);
        return header;
    }

    protected Box createControlBox() {
        this.controlBox = Box.createHorizontalBox();
        this.populateControlBox();
        return this.controlBox;
    }

    public void populateControlBox() {
        if (this.actions != null) {
            for (Action a : this.actions) {
                if (a instanceof TablePanelAction) {
                    ((TablePanelAction)a).setTablePanel(this);
                }
                JButton b = new JButton(a);
                this.controlBox.add(b);
                this.controlBox.add(Box.createHorizontalStrut(5));
            }
        }
        this.controlBox.add(Box.createHorizontalGlue());
        this.controlBox.setAlignmentX(0.0f);
    }

    public void refresh() {
        if (this.reportListView != null) {
            this.reportListView.refresh();
        }
        if (this.filterView != null) {
            this.filterView.refresh();
        }
        this.table.refresh();
    }

    public void selectAll() {
        this.table.selectAll();
    }

    public void unSelectAll() {
        this.table.unSelectAll();
    }

    public PageableTable<T> getTable() {
        return this.table;
    }

    public void setTable(PageableTable table) {
        this.table = table;
    }

    public View<Object> getFilterView() {
        return this.filterView;
    }

    public void setFilterView(View<Object> filterView) {
        this.filterView = filterView;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public PersistentService<T, Serializable> getPersistentService() {
        return this.getDataSource();
    }

    public void setPersistentService(PersistentService<T, ? extends Serializable> ps) {
        this.table.setDataSource((PageableDataSource<T>)ps);
    }

    public Window getDialog() {
        try {
            Window dlg = this.table.getEditor();
            if (dlg instanceof View && this.propertyValues != null) {
                View view = (View)((Object)dlg);
                new BeanWrapperImpl(view.getModel()).setPropertyValues(this.propertyValues);
                view.refresh();
            }
            return dlg;
        }
        catch (BeanCreationException bce) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can't get editor [" + this.table.getEditorName() + "]"));
            }
            log.error((Object)bce);
            return null;
        }
    }

    public Window getDialog(Object toEdit) {
        try {
            return this.table.getEditor(toEdit);
        }
        catch (BeanCreationException bce) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can't get editor [" + this.table.getEditorName() + "]"));
            }
            return null;
        }
    }

    public String getEditorName() {
        return this.table.getEditorName();
    }

    public void setEditorName(String editorName) {
        this.table.setEditorName(editorName);
    }

    public ReportListView getReportListView() {
        return this.reportListView;
    }

    public void setReportListView(ReportListView reportListView) {
        this.reportListView = reportListView;
    }

    public PersistentService<T, Serializable> getDataSource() {
        return (PersistentService)this.table.getDataSource();
    }

    public Object getFilter() {
        return this.table.getFilter();
    }

    public String getSortProperty() {
        return this.table.getSortPropertyName();
    }

    public Page.Order getSortOrder() {
        return this.table.getOrder();
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
        if (this.controlBox != null) {
            this.controlBox.removeAll();
            this.populateControlBox();
        }
    }

    public GuiFactory getGuiFactory() {
        return this.guiFactory;
    }

    public void setGuiFactory(GuiFactory guiFactory) {
        this.guiFactory = guiFactory;
    }

    public List<T> getSelected() {
        List<Serializable> keys = this.table.getChecked();
        ArrayList<Object> selected = new ArrayList<Object>();
        for (Serializable id : keys) {
            Object t = this.getPersistentService().get(id);
            if (t == null) continue;
            selected.add(this.getPersistentService().get(id));
        }
        return selected;
    }

    public List<T> getVisibleSelected() {
        return this.table.getVisibleSelected();
    }

    public PropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(PropertyValues propertyValues) {
        this.propertyValues = propertyValues;
    }

    public void addEditorListener(EditorListener listener) {
        this.table.addEditorListener(listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this.table.removeEditorListener(listener);
    }
}

