/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.table;

import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.GuiFactory;
import info.joseluismartin.gui.ListTableModel;
import info.joseluismartin.gui.PageableTable;
import info.joseluismartin.gui.SimpleDialog;
import info.joseluismartin.gui.table.TablePanel;
import info.joseluismartin.logic.CollectionPersistenceService;
import info.joseluismartin.service.PersistentService;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableListView<T>
extends AbstractView<List<T>> {
    private TablePanel<T> table;
    private CollectionPersistenceService<T, Serializable> dataSource = new CollectionPersistenceService();
    private String tableName;
    @Autowired
    private GuiFactory guiFactory;

    public TableListView() {
        this(new ArrayList());
    }

    public TableListView(List<T> model) {
        super(model);
    }

    public TableListView(String tableName) {
        this();
        this.tableName = tableName;
    }

    public void init() {
        if (this.guiFactory != null && this.tableName != null) {
            this.table = (TablePanel)this.guiFactory.getObject(this.tableName);
            this.table.setPersistentService((PersistentService<T, Serializable>)this.dataSource);
        }
    }

    @Override
    protected JComponent buildPanel() {
        if (this.table == null) {
            this.buildTable();
        }
        return this.table;
    }

    private void buildTable() {
        this.table = new TablePanel();
        PageableTable pageableTable = new PageableTable();
        ListTableModel ltm = new ListTableModel();
        ltm.setUsingIntrospection(true);
        pageableTable.setTableModel(ltm);
        pageableTable.init();
        this.table.setTable(pageableTable);
        this.table.setPersistentService((PersistentService<T, Serializable>)this.dataSource);
        this.table.init();
    }

    @Override
    public void onSetModel(List<T> model) {
        if (model != null && this.table != null) {
            this.dataSource.setCollection(model);
            this.table.getTable().getPaginator().firstPage();
        }
    }

    public static void main(String[] args) {
        TableListView v = new TableListView();
        SimpleDialog dlg = new SimpleDialog(v.getPanel());
        dlg.setSize(new Dimension(1024, 800));
        dlg.setVisible(true);
    }

    public GuiFactory getGuiFactory() {
        return this.guiFactory;
    }

    public void setGuiFactory(GuiFactory guiFactory) {
        this.guiFactory = guiFactory;
    }
}

