/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.table;

import info.joseluismartin.gui.View;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.table.TablePanelAction;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;

public class HideShowFilterAction
extends TablePanelAction {
    public static final String DEFAULT_SHOW_FILTER_ICON = "/images/table/22x22/filter-show.png";
    public static final String DEFAULT_HIDE_FILTER_ICON = "/images/table/22x22/filter-hide.png";
    private static final long serialVersionUID = 1L;
    private Icon showFilterIcon;
    private Icon hideFilterIcon;

    public void init() {
        this.showFilterIcon = FormUtils.getIcon(this.showFilterIcon, DEFAULT_SHOW_FILTER_ICON);
        this.hideFilterIcon = FormUtils.getIcon(this.hideFilterIcon, DEFAULT_HIDE_FILTER_ICON);
        this.setIcon(this.hideFilterIcon);
        this.setName(this.messageSource.getMessage("HideShowFilterAction.hideFilter"));
    }

    public void actionPerformed(ActionEvent e) {
        View<Object> filterView = this.getTablePanel().getFilterView();
        if (filterView != null) {
            filterView.getPanel().setVisible(!filterView.getPanel().isVisible());
            String value = filterView.getPanel().isVisible() ? this.messageSource.getMessage("HideShowFilterAction.hideFilter") : this.messageSource.getMessage("HideShowFilterAction.showFilter");
            Icon icon = filterView.getPanel().isVisible() ? this.hideFilterIcon : this.showFilterIcon;
            this.setName(value);
            this.setIcon(icon);
        } else {
            ((JButton)e.getSource()).setEnabled(false);
        }
    }

    public Icon getShowFilterIcon() {
        return this.showFilterIcon;
    }

    public void setShowFilterIcon(Icon showFilterIcon) {
        this.showFilterIcon = showFilterIcon;
    }
}

