/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.report;

import info.joseluismartin.dao.Page;
import info.joseluismartin.gui.report.JRParameterEditorDialog;
import info.joseluismartin.gui.report.ReportFileResolver;
import info.joseluismartin.reporting.Report;
import info.joseluismartin.reporting.ReportingException;
import info.joseluismartin.reporting.datasource.PageJRDatasourceAdapter;
import info.joseluismartin.service.PersistentService;
import info.joseluismartin.util.ZipFileUtils;
import info.joseluismartin.util.processor.FileProcessor;
import info.joseluismartin.util.processor.JasperReportFileProcessor;
import info.joseluismartin.util.processor.JasperReportXMLFileProcessor;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReportManager {
    private static final Log log = LogFactory.getLog(ReportManager.class);
    private DataSource dataSource;

    public void showReport(Report report, PersistentService<Object, Serializable> service, Object filter, String sortPropertyName, Page.Order sortOrder, String outputType) throws Exception {
        PageJRDatasourceAdapter dataSource = new PageJRDatasourceAdapter(true);
        Page page = new Page(10, 0, sortPropertyName, sortOrder);
        page.setFilter(filter);
        page.setPageableDataSource(service);
        dataSource.setPage(page);
        JRDataSourceFileStrategy st = new JRDataSourceFileStrategy();
        try {
            st.processFile(report, outputType, dataSource);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showReport(Report report, DataSource dataSource, String outputType) throws ReportingException {
        ConnectionFileStrategy st = new ConnectionFileStrategy();
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            boolean continueWithReport = st.preprocessFile(report);
            if (continueWithReport) {
                st.processFile(report, outputType, conn);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public static String getPrefix(String fileName) {
        String name = fileName != null ? fileName : "";
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(0, name.lastIndexOf(46));
    }

    public static String getSuffix(String fileName) {
        String name = fileName != null ? fileName : "";
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(index);
    }

    protected abstract JRParameterEditorDialog createEditorDialog();

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ProcessFileStrategy {
        private Map<String, Object> parameters = new HashMap<String, Object>();
        private boolean interactive = true;
        private FileProcessor fileProcessor;

        public abstract void setReportDataSource(FileProcessor var1, Object var2);

        public boolean preprocessFile(Report report) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ReportManager. Preprocess file: hasQuery -> " + report.getHasQuery()));
            }
            if (report.getHasQuery().booleanValue()) {
                JasperReport jasperReport = report.newJasperReport();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Parameters in jasperReport");
                }
                HashMap<String, JRParameter> jrParameters = new HashMap<String, JRParameter>();
                for (JRParameter param : jasperReport.getParameters()) {
                    if (param.isSystemDefined() || !param.isForPrompting()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Param to fill from paramEntry: " + param.getName()));
                    }
                    jrParameters.put(param.getName(), param);
                }
                if (!jrParameters.isEmpty() && this.interactive && !this.showParameterDialog(jrParameters)) {
                    return false;
                }
            }
            return true;
        }

        private boolean showParameterDialog(Map<String, JRParameter> jrParameters) {
            JRParameterEditorDialog dialog = ReportManager.this.createEditorDialog();
            dialog.setParameters(jrParameters);
            dialog.initialize();
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return false;
            }
            this.parameters = dialog.getReturnValues();
            return true;
        }

        public void processFile(Report report, String outputType, Object reportDataSource) throws ReportingException, IOException {
            block11: {
                if (report == null || report.getData() == null) {
                    return;
                }
                String suffix = ReportManager.getSuffix(report.getFileName());
                try {
                    File file = File.createTempFile(ReportManager.getPrefix(report.getFileName()), suffix);
                    file.deleteOnExit();
                    FileUtils.writeByteArrayToFile((File)file, (byte[])report.getData());
                    if (".zip".equalsIgnoreCase(suffix)) {
                        String dir = System.getProperty("java.io.tmpdir") + "/" + ReportManager.getPrefix(report.getFileName());
                        ZipFileUtils.unzip((ZipFile)new ZipFile(file), (String)dir);
                        File dirFile = new File(dir);
                        this.parameters.put("REPORT_FILE_RESOLVER", (Object)new ReportFileResolver(dirFile));
                        Iterator iter = FileUtils.iterateFiles((File)dirFile, (String[])new String[]{"jrxml", "jasper"}, (boolean)false);
                        if (iter.hasNext()) {
                            file = (File)iter.next();
                            suffix = ReportManager.getSuffix(file.getName());
                        }
                    }
                    if (".jasper".equals(suffix)) {
                        this.fileProcessor = new JasperReportFileProcessor();
                    } else if (".jrxml".equals(suffix)) {
                        this.fileProcessor = new JasperReportXMLFileProcessor();
                    } else {
                        throw new ReportingException("Process not yet implemented for file type " + suffix);
                    }
                    this.fileProcessor.setParameters(this.parameters);
                    this.setReportDataSource(this.fileProcessor, reportDataSource);
                    this.fileProcessor.processFile(file, outputType, report.getHasQuery().booleanValue());
                    if (!this.interactive || !Desktop.isDesktopSupported()) break block11;
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        File outputFile = File.createTempFile(ReportManager.getPrefix(report.getFileName()), "." + outputType);
                        outputFile.deleteOnExit();
                        FileUtils.writeByteArrayToFile((File)outputFile, (byte[])this.fileProcessor.getRawData());
                        desktop.open(outputFile);
                    }
                    catch (IOException e) {
                        throw new ReportingException("No ha sido posible abrir el fichero del informe: " + report.getFileName(), (Throwable)e);
                    }
                }
                catch (IOException e) {
                    throw new ReportingException("No ha sido posible abrir el fichero del informe: " + report.getFileName(), (Throwable)e);
                }
            }
        }

        public boolean isInteractive() {
            return this.interactive;
        }

        public void setInteractive(boolean interactive) {
            this.interactive = interactive;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        public FileProcessor getFileProcessor() {
            return this.fileProcessor;
        }

        public void setFileProcessor(FileProcessor fileProcessor) {
            this.fileProcessor = fileProcessor;
        }
    }

    public class ConnectionFileStrategy
    extends ProcessFileStrategy {
        public void setReportDataSource(FileProcessor fp, Object obj) {
            fp.setConnection((Connection)obj);
        }
    }

    public class JRDataSourceFileStrategy
    extends ProcessFileStrategy {
        public void setReportDataSource(FileProcessor fp, Object obj) {
            fp.setService((JRDataSource)obj);
        }
    }
}

