/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.report;

import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.list.ListComboBoxModel;
import info.joseluismartin.gui.report.ReportManager;
import info.joseluismartin.reporting.Report;
import info.joseluismartin.reporting.ReportDataProvider;
import info.joseluismartin.reporting.ReportEventListener;
import info.joseluismartin.reporting.ReportType;
import info.joseluismartin.reporting.ReportingException;
import info.joseluismartin.service.PersistentService;
import info.joseluismartin.service.ReportService;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import javax.sql.DataSource;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportListView
extends AbstractView<Report>
implements ReportEventListener {
    private JComboBox reportCombo = FormUtils.newCombo(20);
    private ReportService reportService;
    private Icon pdfIcon;
    private Icon excelIcon;
    private ReportType reportType;
    private ReportManager reportManager;
    private ReportDataProvider<Object, Serializable> reportProvider;
    private DataSource dataSource;

    public ReportListView(Report model) {
        this.setModel(model);
    }

    public ReportListView() {
        this(new Report());
    }

    public void init() {
        this.getPanel();
        this.refresh();
    }

    @Override
    protected void doRefresh() {
        if (this.getModel() == null) {
            return;
        }
        List reportList = this.reportService.getReportsByType(this.reportType);
        Object selected = this.reportCombo.getSelectedItem() != null ? this.reportCombo.getSelectedItem() : this.getModel();
        this.reportCombo.removeAllItems();
        this.reportCombo.setModel(new ListComboBoxModel(reportList));
        this.reportCombo.setSelectedItem(selected);
    }

    @Override
    protected JComponent buildPanel() {
        Box box = Box.createHorizontalBox();
        List reportList = this.reportService.getReportsByType(this.reportType);
        this.reportCombo.setModel(new ListComboBoxModel(reportList));
        this.reportCombo.setSelectedItem(this.getModel());
        box.add(this.reportCombo);
        JButton viewPdfButton = new JButton(new ViewFileAction(this.pdfIcon, "pdf"));
        JButton viewExcelButton = new JButton(new ViewFileAction(this.excelIcon, "xls"));
        box.add(viewPdfButton);
        box.add(viewExcelButton);
        return box;
    }

    private void showFile(Report model, String reportOutputType) {
        if (model.getHasQuery().booleanValue()) {
            try {
                this.reportManager.showReport(model, this.dataSource, reportOutputType);
            }
            catch (ReportingException e) {
                JOptionPane.showMessageDialog(this.getPanel(), e.getMessage(), "Error mostrando informe", 0);
            }
        } else if (this.reportProvider != null) {
            try {
                this.reportManager.showReport(model, (PersistentService<Object, Serializable>)this.reportProvider.getDataSource(), this.reportProvider.getFilter(), this.reportProvider.getSortProperty(), this.reportProvider.getSortOrder(), reportOutputType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Icon getPdfIcon() {
        return this.pdfIcon;
    }

    public void setPdfIcon(Icon pdfIcon) {
        this.pdfIcon = pdfIcon;
    }

    public Icon getExcelIcon() {
        return this.excelIcon;
    }

    public void setExcelIcon(Icon excelIcon) {
        this.excelIcon = excelIcon;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType type) {
        this.reportType = type;
    }

    public void setReportProvider(ReportDataProvider reportProvider) {
        this.reportProvider = reportProvider;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void reportChanged(EventObject event) {
        this.doRefresh();
    }

    public ReportManager getReportManager() {
        return this.reportManager;
    }

    public void setReportManager(ReportManager reportManager) {
        this.reportManager = reportManager;
    }

    private class ViewFileAction
    extends AbstractAction {
        private String reportOutputType;

        public ViewFileAction(Icon icon, String reportOutputType) {
            this.reportOutputType = reportOutputType;
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            ReportListView.this.showFile((Report)ReportListView.this.reportCombo.getSelectedItem(), this.reportOutputType);
        }
    }
}

