/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.report;

import info.joseluismartin.dao.filter.ReportFilter;
import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.form.BoxFormBuilder;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.list.ListComboBoxModel;
import info.joseluismartin.logic.PersistentManager;
import info.joseluismartin.reporting.ReportType;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportFilterView
extends AbstractView<ReportFilter> {
    private static final int COMBO_WIDTH = 20;
    private JTextField reportName = new JTextField();
    private JComboBox reportType = FormUtils.newCombo(20);
    private PersistentManager<ReportType, Long> reportTypeService;

    public ReportFilterView() {
        this(new ReportFilter());
    }

    public ReportFilterView(ReportFilter reportFilter) {
        this.setModel(reportFilter);
    }

    public void init() {
        this.bind(this.reportName, "name");
        this.bind(this.reportType, "type");
        this.refresh();
    }

    @Override
    public void doRefresh() {
        List reportTypeList = this.reportTypeService.getAll();
        reportTypeList.add(0, null);
        this.reportType.setModel(new ListComboBoxModel(reportTypeList));
    }

    @Override
    protected JComponent buildPanel() {
        BoxFormBuilder b = new BoxFormBuilder();
        b.add("Nombre: ", this.reportName);
        b.add("Tipo: ", this.reportType);
        JComponent c = b.getForm();
        return c;
    }

    public PersistentManager<ReportType, Long> getReportTypeService() {
        return this.reportTypeService;
    }

    public void setReportTypeService(PersistentManager<ReportType, Long> reportService) {
        this.reportTypeService = reportService;
    }
}

