/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.report;

import info.joseluismartin.gui.SpringUtilities;
import info.joseluismartin.gui.report.EditorFactory;
import info.joseluismartin.gui.report.ReportParameterEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import net.sf.jasperreports.engine.JRParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRParameterEditorDialog
extends JDialog {
    private static final long serialVersionUID = -5861091649245443018L;
    private Map<String, JRParameter> parameters;
    private Map<String, ReportParameterEditor> editors = new HashMap<String, ReportParameterEditor>();
    private Map<String, Object> returnValues;
    private boolean canceled;
    private EditorFactory editorFactory;

    public JRParameterEditorDialog() {
        this((Frame)null, true);
    }

    public JRParameterEditorDialog(Frame parent, boolean modal, Map<String, JRParameter> jrParameters) {
        super(parent, modal);
        this.parameters = jrParameters;
        this.initialize();
    }

    public JRParameterEditorDialog(Frame parent, boolean modal) {
        super(parent, modal);
    }

    public void initialize() {
        this.setTitle("Par\u00c3\u00a1metros del informe");
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createTitledBorder(""));
        borderPanel.setMinimumSize(borderPanel.getPreferredSize());
        borderPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JButton acceptButton = new JButton(new AcceptAction());
        acceptButton.setText("Aceptar");
        JButton cancelButton = new JButton(new CancelAction());
        cancelButton.setText("Cancelar");
        acceptButton.setAlignmentX(0.5f);
        cancelButton.setAlignmentX(0.5f);
        buttonPanel.add(acceptButton);
        buttonPanel.add(cancelButton);
        JPanel paramPanel = new JPanel(new SpringLayout());
        for (JRParameter param : this.parameters.values()) {
            ReportParameterEditor propertyEditor = this.editorFactory.getParameterEditor(param);
            propertyEditor.getEditor().addKeyListener(new KeyPressed());
            JLabel label = new JLabel(param.getName());
            label.setLabelFor(propertyEditor.getEditor());
            paramPanel.add(label);
            paramPanel.add(propertyEditor.getEditor());
            this.editors.put(param.getName(), propertyEditor);
        }
        borderPanel.add((Component)paramPanel, "First");
        borderPanel.add((Component)buttonPanel, "Last");
        SpringUtilities.makeCompactGrid(paramPanel, this.parameters.size(), 2, 6, 6, 6, 6);
        this.add(borderPanel);
        this.setLocationRelativeTo(null);
        this.pack();
    }

    public Map<String, Object> getReturnValues() {
        return this.returnValues;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void updateReturnValues() {
        if (this.returnValues == null) {
            this.returnValues = new HashMap<String, Object>();
        }
        for (String key : this.editors.keySet()) {
            try {
                ReportParameterEditor editor = this.editors.get(key);
                this.returnValues.put(key, editor.getValue());
            }
            catch (Exception e) {
                String msg = "El valor introducido no es correcto para el par\u00c3\u00a1metro " + this.parameters.get(key).getName();
                JOptionPane.showMessageDialog(this, msg, "Error en par\u00c3\u00a1metro", 0);
            }
        }
    }

    public static void main(String[] args) {
        JRParameterEditorDialog d = new JRParameterEditorDialog(null, true);
        d.setVisible(true);
    }

    public EditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorFactory(EditorFactory editorFactory) {
        this.editorFactory = editorFactory;
    }

    public Map<String, JRParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, JRParameter> parameters) {
        this.parameters = parameters;
    }

    class KeyPressed
    implements KeyListener {
        KeyPressed() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                new AcceptAction().actionPerformed(null);
            } else if (e.getKeyCode() == 27) {
                new CancelAction().actionPerformed(null);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    public class CancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent arg0) {
            JRParameterEditorDialog.this.setCanceled(true);
            JRParameterEditorDialog.this.setVisible(false);
            JRParameterEditorDialog.this.dispose();
        }
    }

    public class AcceptAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent arg0) {
            JRParameterEditorDialog.this.updateReturnValues();
            JRParameterEditorDialog.this.setVisible(false);
        }
    }
}

