/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.list;

import info.joseluismartin.gui.list.ListListModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import org.apache.commons.lang.ObjectUtils;

public class ListComboBoxModel
extends ListListModel
implements MutableComboBoxModel {
    private static final long serialVersionUID = 1L;
    private Object selectedItem;
    private boolean allowNullSelection = true;

    public ListComboBoxModel() {
        this((List)new ArrayList());
    }

    public ListComboBoxModel(List list) {
        this(list, true);
    }

    public ListComboBoxModel(List list, boolean allowNullSelection) {
        super(list);
        if (list != null && list.size() > 0) {
            this.setSelectedItem(list.get(0));
        }
        this.allowNullSelection = allowNullSelection;
    }

    public void addElement(Object obj) {
        this.getList().add(obj);
        int index = this.getList().indexOf(obj);
        this.fireIntervalAdded(this, index, index);
    }

    public void insertElementAt(Object obj, int index) {
        this.getList().add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeElement(Object obj) {
        int index = this.getList().indexOf(obj);
        if (this.getList().remove(obj)) {
            this.fireIntervalRemoved(this, index, index);
        }
        if (ObjectUtils.equals((Object)this.selectedItem, (Object)obj)) {
            this.selectedItem = this.getList().size() > 0 ? this.getList().get(0) : null;
        }
    }

    public void removeElementAt(int index) {
        this.getList().remove(index);
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object item) {
        if (item == null) {
            this.selectNullItem();
            this.fireContentsChanged(this, -1, -1);
        } else if (!item.equals(this.selectedItem)) {
            int index = this.getList().indexOf(item);
            if (index != -1) {
                this.selectedItem = item;
            } else {
                this.selectNullItem();
            }
            this.fireContentsChanged(this, index, index);
        }
    }

    private void selectNullItem() {
        if (this.allowNullSelection) {
            this.selectedItem = null;
        } else if (this.getList().size() > 0) {
            this.setSelectedItem(this.getList().get(0));
        }
    }
}

