/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.form;

import info.joseluismartin.gui.form.FormFocusTransversalPolicy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;

public class SimpleBoxFormBuilder {
    public static final int SIZE_UNDEFINED = Short.MAX_VALUE;
    private static final Log log = LogFactory.getLog(SimpleBoxFormBuilder.class);
    private Box container = Box.createHorizontalBox();
    private List<Box> columns = new ArrayList<Box>();
    private List<Integer> columnsWidth = new ArrayList<Integer>();
    private List<Integer> rowsHeight = new ArrayList<Integer>();
    private int index = 0;
    private int rows = 0;
    private int rowHeight = 25;
    private int defaultRowHeight = 25;
    private int defaultSpace = 5;
    private int charWidth = 6;
    private boolean debug = false;
    private boolean fixedHeight = false;
    private MessageSource messageSource;
    private FormFocusTransversalPolicy focusTransversal = new FormFocusTransversalPolicy();
    private Border border = null;

    public SimpleBoxFormBuilder() {
        this(SimpleBoxFormBuilder.calculateDefaultHeight(), null);
    }

    public SimpleBoxFormBuilder(Border border) {
        this(SimpleBoxFormBuilder.calculateDefaultHeight(), border);
    }

    public SimpleBoxFormBuilder(int defaultRowHeight) {
        this(defaultRowHeight, null);
    }

    public SimpleBoxFormBuilder(int defaultRowHeight, Border border) {
        this.defaultRowHeight = defaultRowHeight;
        this.border = border;
    }

    public void add(Component c) {
        if (this.debug && c instanceof JComponent) {
            ((JComponent)c).setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        }
        this.addBox(c);
        if (this.rowHeight < Short.MAX_VALUE) {
            Dimension d = c.getPreferredSize();
            d.height = this.rowHeight;
            c.setPreferredSize(d);
            c.setMinimumSize(d);
            if (!c.isMaximumSizeSet() || c.getMaximumSize().getHeight() > (double)this.rowHeight) {
                c.setMaximumSize(new Dimension(Short.MAX_VALUE, this.rowHeight));
            }
        }
    }

    public void add(Component c, int maxWidth) {
        this.add(c);
        this.setMaxWidth(maxWidth);
    }

    public void addBox(Component c) {
        if (this.rows == 0 && this.rowsHeight.isEmpty()) {
            log.warn((Object)"You must call row() before adding components. I will add a row with default height for you");
            this.row();
        }
        Box column = this.getColumn();
        if (this.rows > 1) {
            column.add(Box.createVerticalStrut(this.defaultSpace));
        }
        column.add(c);
        if (!(c instanceof JLabel)) {
            this.focusTransversal.add(c);
        } else if (StringUtils.isEmpty((String)((JLabel)c).getText())) {
            ((JLabel)c).setText(" ");
        }
        ++this.index;
    }

    private Box getColumn() {
        Box column = null;
        if (this.index < this.columns.size()) {
            column = this.columns.get(this.index);
        } else {
            if (!this.columns.isEmpty()) {
                this.container.add(Box.createHorizontalStrut(this.defaultSpace));
            }
            column = Box.createVerticalBox();
            this.columns.add(column);
            this.container.add(column);
            this.columnsWidth.add(0);
            if (this.debug) {
                column.setBorder(BorderFactory.createLineBorder(Color.RED));
            }
        }
        return column;
    }

    public void add(String name, Component c) {
        JLabel label = new JLabel(name);
        this.add(label);
        Rectangle2D rec = label.getFontMetrics(label.getFont()).getStringBounds(name, this.container.getGraphics());
        this.setMaxWidth(rec.getBounds().width + 10);
        this.add(c);
    }

    public void setMaxWidth(int i) {
        if (i > this.columnsWidth.get(this.index - 1)) {
            this.columnsWidth.set(this.index - 1, i);
        }
    }

    public void row() {
        this.row(this.defaultRowHeight);
    }

    public void row(int rowHeight) {
        this.index = 0;
        ++this.rows;
        this.rowsHeight.add(rowHeight);
        this.rowHeight = rowHeight;
    }

    public JComponent getForm() {
        int columnHeight = 0;
        for (int h : this.rowsHeight) {
            columnHeight += h;
        }
        columnHeight += this.rows * this.defaultSpace;
        for (int i = 0; i < this.columns.size(); ++i) {
            Box box = this.columns.get(i);
            int maxWidth = this.columnsWidth.get(i) == 0 ? Short.MAX_VALUE : this.columnsWidth.get(i);
            box.setMaximumSize(new Dimension(maxWidth, columnHeight));
            if (maxWidth >= Short.MAX_VALUE || columnHeight >= Short.MAX_VALUE) continue;
            box.setMinimumSize(new Dimension(maxWidth, columnHeight));
            box.setPreferredSize(new Dimension(maxWidth, columnHeight));
        }
        this.container.setFocusTraversalPolicy(this.focusTransversal);
        this.container.setFocusTraversalPolicyProvider(true);
        this.container.setSize(Short.MAX_VALUE, columnHeight);
        if (this.isFixedHeight()) {
            Dimension maxSize = new Dimension(Short.MAX_VALUE, columnHeight);
            if (this.container.isMaximumSizeSet()) {
                maxSize = this.container.getMaximumSize();
                maxSize.height = columnHeight;
            }
            this.container.setMaximumSize(maxSize);
        }
        if (this.isDebug()) {
            this.container.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        }
        if (this.border != null) {
            this.container.setBorder(this.border);
        }
        return this.container;
    }

    public void reset() {
        this.columns = new ArrayList<Box>();
        this.columnsWidth = new ArrayList<Integer>();
        this.rowsHeight = new ArrayList<Integer>();
        this.container = Box.createHorizontalBox();
        this.index = 0;
        this.rows = 0;
        this.focusTransversal = new FormFocusTransversalPolicy();
    }

    public void next() {
        this.getColumn();
        ++this.index;
    }

    public int getHeight() {
        return this.rowHeight;
    }

    public void setHeight(int height) {
        this.rowHeight = height;
        if (this.rowsHeight.size() > 0 && this.rows > 0) {
            this.rowsHeight.remove(this.rows - 1);
            this.rowsHeight.add(height);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public boolean isFixedHeight() {
        return this.fixedHeight;
    }

    public void setFixedHeight(boolean fixedHeight) {
        this.fixedHeight = fixedHeight;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public int getDefaultSpace() {
        return this.defaultSpace;
    }

    public void setDefaultSpace(int defaultSpace) {
        this.defaultSpace = defaultSpace;
    }

    public int getCharWidth() {
        return this.charWidth;
    }

    public void setCharWidth(int charWidth) {
        this.charWidth = charWidth;
    }

    private static int calculateDefaultHeight() {
        Dimension d = new JTextField().getPreferredSize();
        return d != null ? d.height : 25;
    }
}

