/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.form;

import info.joseluismartin.gui.SimpleDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormUtils {
    public static final Icon CANCEL_ICON = FormUtils.getIcon("images/16x16/dialog-cancel.png");
    public static final Icon OK_ICON = FormUtils.getIcon("/images/16x16/dialog-ok.png");
    private static final Log log = LogFactory.getLog(FormUtils.class);

    public static void link(JComboBox primary, JComboBox dependent, String propertyName) {
        FormUtils.link(primary, dependent, propertyName, false);
    }

    public static void link(final JComboBox primary, final JComboBox dependent, final String propertyName, final boolean addNull) {
        primary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object selected = primary.getSelectedItem();
                if (selected != null) {
                    BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)selected);
                    if (wrapper.isWritableProperty(propertyName)) {
                        Collection collection = (Collection)wrapper.getPropertyValue(propertyName);
                        Vector<Object> vector = new Vector<Object>(collection);
                        if (addNull) {
                            vector.add(0, null);
                        }
                        DefaultComboBoxModel model = new DefaultComboBoxModel(vector);
                        dependent.setModel(model);
                    } else {
                        log.error((Object)("Can't write on propety '" + propertyName + "' of class: '" + selected.getClass() + "'"));
                    }
                }
            }
        });
    }

    public static List<Object> getComboModelList(ComboBoxModel model) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < model.getSize(); ++i) {
            list.add(model.getElementAt(i));
        }
        return list;
    }

    public static JComboBox newCombo(int chars) {
        StringBuilder sb = new StringBuilder(chars);
        while (chars-- > 0) {
            sb.append("X");
        }
        JComboBox<String> combo = new JComboBox<String>();
        combo.setPrototypeDisplayValue(sb.toString());
        return combo;
    }

    public static void setBold(JLabel label) {
        label.setFont(label.getFont().deriveFont(1));
    }

    public static Border createTitledBorder(String name) {
        Border margin = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder title = BorderFactory.createTitledBorder(name);
        return BorderFactory.createCompoundBorder(title, margin);
    }

    public static JButton newOKButton() {
        String text = UIManager.getString("OptionPane.okButtonText");
        Icon icon = UIManager.getIcon("OptionPane.okIcon");
        if (icon == null) {
            icon = OK_ICON;
        }
        int mnemonic = FormUtils.getMnemonic("OptionPane.okButtonMnemonic");
        JButton b = new JButton(text, icon);
        b.setMnemonic(mnemonic);
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.5f);
        return b;
    }

    public static JButton newCancelButton() {
        String text = UIManager.getString("OptionPane.cancelButtonText");
        Icon icon = UIManager.getIcon("OptionPane.cancelIcon");
        if (icon == null) {
            icon = CANCEL_ICON;
        }
        int mnemonic = FormUtils.getMnemonic("OptionPane.cancelButtonMnemonic");
        JButton b = new JButton(text, icon);
        b.setMnemonic(mnemonic);
        b.setAlignmentX(0.5f);
        b.setAlignmentY(0.5f);
        return b;
    }

    private static int getMnemonic(String key) {
        String value = (String)UIManager.get(key);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static Icon getIcon(String url) {
        ClassPathResource resource = new ClassPathResource(url);
        ImageIcon icon = null;
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(resource.getURL());
            icon = new ImageIcon(image);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return icon;
    }

    public static Icon getIcon(Icon icon, String url) {
        return icon != null ? icon : FormUtils.getIcon(url);
    }

    public static JMenu toMenu(List<Action> actions) {
        JMenu menu = new JMenu();
        for (Action a : actions) {
            menu.add(a);
        }
        return menu;
    }

    public static JLabel newLabelForBox(String message) {
        JLabel label = new JLabel(message);
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, label.getFont().getSize() + 10));
        label.setAlignmentX(0.5f);
        return label;
    }

    public static void showError(String message) {
        FormUtils.showError(null, message);
    }

    public static void showError(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Error", 0);
    }

    public static JDialog newDialog(Component component) {
        return FormUtils.newDialog(null, component);
    }

    public static JDialog newDialog(Window owner, Component component) {
        return new SimpleDialog(owner, component);
    }

    public static Border createEmptyBorder(int size) {
        return BorderFactory.createEmptyBorder(size, size, size, size);
    }
}

