/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.form;

import info.joseluismartin.gui.form.SimpleBoxFormBuilder;
import java.awt.Component;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class BoxFormBuilder {
    private Stack<SimpleBoxFormBuilder> stack = new Stack();
    SimpleBoxFormBuilder builder;

    public BoxFormBuilder() {
        this.builder = new SimpleBoxFormBuilder();
    }

    public BoxFormBuilder(Border border) {
        this.builder = new SimpleBoxFormBuilder(border);
    }

    public BoxFormBuilder(int rowHeight) {
        this(rowHeight, null);
    }

    public BoxFormBuilder(int rowHeight, Border border) {
        this.builder = new SimpleBoxFormBuilder(rowHeight, border);
    }

    public void startBox(Border border) {
        boolean debug = this.builder.isDebug();
        this.stack.push(this.builder);
        this.builder = new SimpleBoxFormBuilder(border);
        this.builder.setDebug(debug);
    }

    public void startBox() {
        this.startBox(null);
    }

    public void endBox() {
        JComponent c = this.builder.getForm();
        this.builder = this.stack.pop();
        this.builder.addBox(c);
        this.builder.setHeight(c.getHeight());
    }

    public void add(Component c) {
        this.builder.add(c);
    }

    public void add(Component c, int maxWidth) {
        this.builder.add(c, maxWidth);
    }

    public void add(String name, Component c) {
        this.builder.add(name, c);
    }

    public void setMaxWidth(int i) {
        this.builder.setMaxWidth(i);
    }

    public void row() {
        this.builder.row();
    }

    public JComponent getForm() {
        return this.builder.getForm();
    }

    public void reset() {
        this.builder.reset();
    }

    public void next() {
        this.builder.next();
    }

    public int getHeight() {
        return this.builder.getHeight();
    }

    public void setHeight(int height) {
        this.builder.setHeight(height);
    }

    public boolean isDebug() {
        return this.builder.isDebug();
    }

    public void setDebug(boolean debug) {
        this.builder.setDebug(debug);
    }

    public boolean isFixedHeight() {
        return this.builder.isFixedHeight();
    }

    public void setFixedHeight(boolean fixedHeight) {
        this.builder.setFixedHeight(fixedHeight);
    }

    public void setElastic() {
        this.setHeight(Short.MAX_VALUE);
    }

    public void row(int rowHeight) {
        this.builder.row(rowHeight);
    }

    public int getDefaultRowHeight() {
        return this.builder.getDefaultRowHeight();
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.builder.setDefaultRowHeight(defaultRowHeight);
    }

    public int getDefaultSpace() {
        return this.builder.getDefaultSpace();
    }

    public void setDefaultSpace(int defaultSpace) {
        this.builder.setDefaultSpace(defaultSpace);
    }
}

