/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.View;
import info.joseluismartin.gui.bind.AbstractBinder;
import info.joseluismartin.gui.bind.BinderHolder;
import info.joseluismartin.gui.bind.PropertyBinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewBinder
extends AbstractBinder
implements BinderHolder {
    private static final Log log = LogFactory.getLog(ViewBinder.class);

    @Override
    public void doRefresh() {
        Object value = this.getValue();
        View<Object> view = this.getView();
        view.setModel(value);
        view.refresh();
    }

    private View<Object> getView() {
        View view = (View)this.component;
        return view;
    }

    @Override
    public void doUpdate() {
        View<Object> view = this.getView();
        BindingResult br = view.getBindingResult();
        if (br != null) {
            br.setNestedPath(this.propertyName);
        }
        view.update();
        this.setValue(view.getModel());
        if (br != null && view.getBindingResult().hasErrors()) {
            for (ObjectError oe : view.getBindingResult().getAllErrors()) {
                this.getBindingResult().addError(oe);
            }
        }
    }

    @Override
    public PropertyBinder getBinder(String propertyName) {
        View<Object> view = this.getView();
        if (view instanceof BinderHolder) {
            return ((BinderHolder)((Object)view)).getBinder(propertyName);
        }
        log.warn((Object)("View class: [" + view.getClass().getName() + "] " + "must implements BinderHolder to validate property: [" + propertyName + "]"));
        return null;
    }
}

