/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.bind.AbstractBinder;
import info.joseluismartin.gui.bind.ConfigurableControlAccessorFactory;
import info.joseluismartin.gui.bind.ControlAccessor;
import info.joseluismartin.gui.bind.ControlAccessorFactory;
import info.joseluismartin.text.FormatUtils;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBinder
extends AbstractBinder {
    private static final Log log = LogFactory.getLog(ControlBinder.class);
    private ControlAccessorFactory controlAccessorFactory;
    private ControlAccessor controlAccessor;

    public ControlBinder() {
        this(new ConfigurableControlAccessorFactory());
    }

    public ControlBinder(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
    }

    @Override
    public void doBind() {
        this.controlAccessor = this.controlAccessorFactory.getControlAccessor(this.component);
    }

    @Override
    protected void doRefresh() {
        Printer<Object> printer;
        Object value = this.getValue();
        if (value != null && this.controlAccessor.isTextControl() && (printer = this.getPrinter()) != null) {
            value = printer.print(value, Locale.getDefault());
        }
        this.controlAccessor.setControlValue(value);
    }

    @Override
    protected void doUpdate() {
        Parser<?> parser;
        Object value = this.controlAccessor.getControlValue();
        if (this.controlAccessor.isTextControl() && (parser = this.getParser()) != null) {
            try {
                value = parser.parse((String)value, Locale.getDefault());
            }
            catch (ParseException e) {
                log.error((Object)("Can't parse String : " + value.toString()));
            }
        }
        this.setValue(value);
    }

    protected Printer<Object> getPrinter() {
        return FormatUtils.getPrinter(this.getModel().getClass(), (String)this.propertyName);
    }

    protected Parser<?> getParser() {
        return FormatUtils.getParser(this.getModel().getClass(), (String)this.propertyName);
    }

    public ControlAccessorFactory getControlAccessorFactory() {
        return this.controlAccessorFactory;
    }

    public void setControlAccessorFactory(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
    }
}

