/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.View;
import info.joseluismartin.gui.bind.BinderFactory;
import info.joseluismartin.gui.bind.CollectionPersistentServiceBinder;
import info.joseluismartin.gui.bind.ConfigurableControlAccessorFactory;
import info.joseluismartin.gui.bind.ControlAccessorFactory;
import info.joseluismartin.gui.bind.ControlBinder;
import info.joseluismartin.gui.bind.PropertyBinder;
import info.joseluismartin.gui.bind.ViewBinder;
import info.joseluismartin.logic.CollectionPersistenceService;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableBinderFactory
implements BinderFactory {
    private static final Log log = LogFactory.getLog(BinderFactory.class);
    private static BinderFactory defaultFactory;
    private ControlAccessorFactory controlAccessorFactory;
    private Map<Class<?>, Class<? extends PropertyBinder>> binders = new Hashtable();
    private boolean mergeBinders = true;

    public ConfigurableBinderFactory() {
        this(ConfigurableControlAccessorFactory.getDefaultFactory());
    }

    public ConfigurableBinderFactory(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
        this.initDefaultBinders();
    }

    @Override
    public PropertyBinder getBinder(Class<?> clazz) {
        Class<? extends PropertyBinder> binderClass = null;
        PropertyBinder binder = null;
        binderClass = this.binders.get(clazz);
        if (binderClass == null) {
            List superclasses = ClassUtils.getAllSuperclasses(clazz);
            superclasses.addAll(ClassUtils.getAllInterfaces(clazz));
            Iterator iter = superclasses.iterator();
            while (iter.hasNext() && binderClass == null) {
                binderClass = this.binders.get(iter.next());
            }
        }
        if (binderClass != null) {
            try {
                binder = binderClass.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
        } else {
            binder = new ControlBinder(this.controlAccessorFactory);
        }
        return binder;
    }

    private void initDefaultBinders() {
        this.binders.put(View.class, ViewBinder.class);
        this.binders.put(CollectionPersistenceService.class, CollectionPersistentServiceBinder.class);
    }

    public static synchronized BinderFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = new ConfigurableBinderFactory();
        }
        return defaultFactory;
    }

    public Map<Class<?>, Class<? extends PropertyBinder>> getBinders() {
        return this.binders;
    }

    public void setBinders(Map<Class<?>, Class<? extends PropertyBinder>> binders) {
        if (!this.mergeBinders) {
            this.binders.clear();
        }
        this.binders.putAll(binders);
    }

    public ControlAccessorFactory getControlAccessorFactory() {
        return this.controlAccessorFactory;
    }

    public void setControlAccessorFactory(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
    }

    public boolean isMergeBinders() {
        return this.mergeBinders;
    }

    public void setMergeBinders(boolean mergeBinders) {
        this.mergeBinders = mergeBinders;
    }
}

