/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.annotations.Reference;
import info.joseluismartin.gui.bind.ControlInitializer;
import info.joseluismartin.gui.list.ListComboBoxModel;
import info.joseluismartin.gui.list.ListListModel;
import info.joseluismartin.service.PersistentService;
import info.joseluismartin.util.BeanUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.ManyToOne;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationControlInitializer
implements ControlInitializer {
    private static final Log log = LogFactory.getLog(AnnotationControlInitializer.class);
    private PersistentService<Object, ? extends Serializable> persistentService;
    private boolean initializeEntities = false;
    private boolean firstNull = false;

    @Override
    public void initialize(Object control, String property, Class<?> clazz) {
        Annotation[] annotations;
        if (this.persistentService == null) {
            log.warn((Object)"Nothing to do without persistent service");
            return;
        }
        Class propertyType = BeanUtils.getPropertyDescriptor(clazz, (String)property).getPropertyType();
        for (Annotation a : annotations = this.getAnnotations(property, clazz)) {
            if (ManyToOne.class.equals(a.annotationType())) {
                List<Object> entities = this.getEntityList(propertyType);
                if (control instanceof JComboBox) {
                    ((JComboBox)control).setModel(new ListComboBoxModel((List)entities));
                    break;
                }
                if (!(control instanceof JList)) break;
                ((JList)control).setModel(new ListListModel(entities));
                break;
            }
            if (!Reference.class.equals(a.annotationType()) || !(control instanceof JComboBox)) continue;
            Reference r = (Reference)a;
            Class type = Void.TYPE.equals(r.target()) ? propertyType : r.target();
            List entities = this.getEntityList(type);
            List values = StringUtils.isEmpty((String)r.property()) ? entities : this.getValueList(entities, r.property());
            ((JComboBox)control).setModel(new ListComboBoxModel(values));
            break;
        }
    }

    private List<Object> getEntityList(Class<?> propertyType) {
        List entities = this.persistentService.getAll(propertyType);
        if (this.isInitializeEntities()) {
            for (Object entity : entities) {
                this.persistentService.initialize(entity);
            }
        }
        if (this.isFirstNull()) {
            entities.add(0, null);
        }
        return entities;
    }

    private List getValueList(List entities, String propertyName) {
        ArrayList<Object> values = new ArrayList<Object>(entities.size());
        for (Object value : entities) {
            if (value == null) {
                values.add(null);
                continue;
            }
            values.add(BeanUtils.getProperty(value, (String)propertyName));
        }
        return values;
    }

    private Annotation[] getAnnotations(String property, Class<?> clazz) {
        Method method;
        Field field = ReflectionUtils.findField(clazz, (String)property);
        Object[] fa = new Annotation[]{};
        if (field != null) {
            fa = field.getAnnotations();
        }
        if ((method = BeanUtils.getPropertyDescriptor(clazz, (String)property).getReadMethod()) != null) {
            Object[] ma = method.getAnnotations();
            Annotation[] annotations = (Annotation[])ArrayUtils.addAll((Object[])fa, (Object[])ma);
            return annotations;
        }
        return fa;
    }

    public PersistentService<Object, ? extends Serializable> getPersistentService() {
        return this.persistentService;
    }

    public void setPersistentService(PersistentService<Object, ? extends Serializable> persistentService) {
        this.persistentService = persistentService;
    }

    public boolean isInitializeEntities() {
        return this.initializeEntities;
    }

    @Override
    public void setInitializeEntities(boolean initializeEntities) {
        this.initializeEntities = initializeEntities;
    }

    public boolean isFirstNull() {
        return this.firstNull;
    }

    public void setFirstNull(boolean firstNull) {
        this.firstNull = firstNull;
    }
}

