/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.beans.SimpleTypeConverter;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.bind.ControlAccessor;
import info.joseluismartin.gui.bind.ControlChangeListener;
import info.joseluismartin.gui.bind.ControlEvent;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.CustomDateEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControlAccessor
implements ControlAccessor {
    private Object control;
    private List<ControlChangeListener> listeners = new ArrayList<ControlChangeListener>();
    private TypeConverter converter = new SimpleTypeConverter();

    public AbstractControlAccessor() {
        this(null);
    }

    public AbstractControlAccessor(Object control) {
        this.setControl(control);
        if (this.converter instanceof PropertyEditorRegistry) {
            PropertyEditorRegistry per = (PropertyEditorRegistry)this.converter;
            per.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(SimpleDateFormat.getDateInstance(3), true));
        }
    }

    @Override
    public void addControlChangeListener(ControlChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeControlChangeListener(ControlChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    protected <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return (T)this.converter.convertIfNecessary(value, requiredType);
    }

    protected void fireControlChange() {
        for (ControlChangeListener l : this.listeners) {
            l.controlChange(new ControlEvent(this.getControl()));
        }
    }

    public Object getControl() {
        return this.control;
    }

    public void setControl(Object control) {
        this.control = control;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.control instanceof Component) {
            ((Component)this.control).setEnabled(enabled);
        } else if (this.control instanceof View) {
            ((View)this.control).enableView(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.control instanceof Component) {
            return ((Component)this.control).isEnabled();
        }
        return true;
    }

    @Override
    public boolean isTextControl() {
        return this.control instanceof JLabel || this.control instanceof JTextComponent;
    }
}

