/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.action;

import info.joseluismartin.gui.Editor;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.ViewDialog;
import info.joseluismartin.gui.action.ViewAction;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.service.PersistentService;
import info.joseluismartin.service.PersistentServiceAware;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewSaveAction<T>
extends ViewAction<T>
implements PersistentServiceAware<T> {
    private static final String DEFAULT_ICON = "/images/16x16/dialog-ok.png";
    private static final String DEFAULT_NAME = "Accept";
    private PersistentService<T, ? extends Serializable> service;

    public ViewSaveAction() {
        this.setIcon(FormUtils.getIcon(DEFAULT_ICON));
        this.setName(DEFAULT_NAME);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.beforeSave();
        this.afterSave(this.save());
    }

    private boolean save() {
        View view = this.getView();
        view.update();
        boolean valid = view.validateView();
        if (valid) {
            if (this.service != null) {
                this.service.save(view.getModel());
            }
            this.getDialog().setVisible(false);
            this.getDialog().dispose();
            if (this.getDialog() instanceof ViewDialog) {
                ((ViewDialog)this.getDialog()).setValue(0);
            }
            if (this.getDialog() instanceof Editor) {
                ((Editor)((Object)this.getDialog())).save();
            }
        } else if (this.onError()) {
            String errorMessage = view.getErrorMessage();
            JOptionPane.showMessageDialog(view.getPanel(), errorMessage, "Error", 0);
        }
        return valid;
    }

    protected boolean onError() {
        return true;
    }

    protected void afterSave(boolean valid) {
    }

    protected void beforeSave() {
    }

    @Deprecated
    public PersistentService<T, ? extends Serializable> getService() {
        return this.service;
    }

    @Deprecated
    public void setService(PersistentService<T, ? extends Serializable> service) {
        this.service = service;
    }

    public void setPersistentService(PersistentService<T, ? extends Serializable> persistentService) {
        this.service = persistentService;
    }
}

