/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.action;

import info.joseluismartin.dao.Page;
import info.joseluismartin.dao.filter.PatternFilter;
import info.joseluismartin.gui.action.AutoCompletionListener;
import info.joseluismartin.service.PersistentService;
import java.util.List;
import javax.swing.JComboBox;

public class FilterAutoCompletionListener
extends AutoCompletionListener {
    public static final String DEFAULT_SORT_PROPERTY = "name";
    private PersistentService persistentService;
    private int maxResults = Short.MAX_VALUE;
    private String sortProperty;

    public FilterAutoCompletionListener() {
    }

    public FilterAutoCompletionListener(JComboBox combo) {
        this(combo, Short.MAX_VALUE);
    }

    public FilterAutoCompletionListener(JComboBox combo, int maxValue) {
        this(combo, Short.MAX_VALUE, DEFAULT_SORT_PROPERTY);
    }

    public FilterAutoCompletionListener(JComboBox combo, int maxResults, String sortProperty) {
        super(combo);
        this.maxResults = maxResults;
        this.sortProperty = sortProperty;
    }

    protected List getList(String editing) {
        Page page = new Page(this.maxResults);
        PatternFilter filter = new PatternFilter();
        filter.setPattern(editing.trim() + "%");
        page.setFilter((Object)filter);
        return this.persistentService.getPage(page).getData();
    }

    public PersistentService getPersistentService() {
        return this.persistentService;
    }

    public void setPersistentService(PersistentService persistentService) {
        this.persistentService = persistentService;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public String getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String sortProperty) {
        this.sortProperty = sortProperty;
    }
}

