/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.Editor;
import info.joseluismartin.gui.EditorEvent;
import info.joseluismartin.gui.EditorListener;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.action.DialogAcceptAction;
import info.joseluismartin.gui.action.ViewAction;
import info.joseluismartin.gui.action.ViewCancelAction;
import info.joseluismartin.gui.bind.ControlChangeListener;
import info.joseluismartin.service.PersistentService;
import info.joseluismartin.service.PersistentServiceAware;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.springframework.validation.BindingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewFrame<T>
extends JFrame
implements View<T>,
Editor<T> {
    private static final long serialVersionUID = 1L;
    private View<T> view;
    private ViewAction<T> acceptAction = new DialogAcceptAction();
    private ViewAction<T> cancelAction = new ViewCancelAction();
    private JButton acceptButton;
    private JButton cancelButton;
    private int windowWidth;
    private int windowHeight;
    private EventListenerList listenerList = new EventListenerList();
    private PersistentService<T, ? extends Serializable> persistentService;

    public ViewFrame() {
    }

    public ViewFrame(Frame owner) {
    }

    public void init() {
        this.acceptAction.setView(this.view);
        this.cancelAction.setView(this.view);
        this.acceptAction.setDialog(this);
        this.cancelAction.setDialog(this);
        this.add((Component)this.view.getPanel(), "Center");
        this.add(this.createButtonBox(), "South");
        this.setTitle(this.view.getModel().toString());
        this.setLocationRelativeTo(null);
        this.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseListener());
    }

    protected Component createButtonBox() {
        this.acceptButton = new JButton(this.acceptAction);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel p = new JPanel();
        p.add(this.acceptButton);
        p.add(this.cancelButton);
        return p;
    }

    @Override
    public void save() {
        Object[] listeners = this.listenerList.getListenerList();
        EditorEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (e == null) {
                e = new EditorEvent(this, this.getModel());
            }
            ((EditorListener)listeners[i + 1]).modelChanged(e);
        }
    }

    public View<T> getView() {
        return this.view;
    }

    public void setView(View<T> view) {
        this.view = view;
    }

    public ViewAction<T> getAcceptAction() {
        return this.acceptAction;
    }

    public void setAcceptAction(ViewAction<T> acceptAction) {
        this.acceptAction = acceptAction;
        this.acceptAction.setView(this.view);
        this.acceptAction.setDialog(this);
    }

    public ViewAction<T> getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(ViewAction<T> cancelAction) {
        this.cancelAction = cancelAction;
        cancelAction.setDialog(this);
        cancelAction.setView(this.view);
    }

    @Override
    public T getModel() {
        return this.view.getModel();
    }

    @Override
    public JComponent getPanel() {
        return this.view.getPanel();
    }

    @Override
    public void refresh() {
        this.view.refresh();
        this.setTitle(this.view.getModel().toString());
    }

    @Override
    public void setModel(T model) {
        this.view.setModel(model);
    }

    @Override
    public void update() {
        this.view.update();
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public boolean validateView() {
        return this.view.validateView();
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    @Override
    public void addEditorListener(EditorListener l) {
        this.listenerList.add(EditorListener.class, l);
    }

    @Override
    public void removeEditorListener(EditorListener l) {
        this.listenerList.remove(EditorListener.class, l);
    }

    @Override
    public boolean isDirty() {
        return this.view.isDirty();
    }

    @Override
    public void enableView(boolean enabled) {
        this.view.enableView(enabled);
        this.acceptButton.setEnabled(enabled);
    }

    @Override
    public BindingResult getBindingResult() {
        return this.view.getBindingResult();
    }

    @Override
    public String getErrorMessage() {
        return this.view.getErrorMessage();
    }

    @Override
    public void addControlChangeListener(ControlChangeListener listener) {
        this.view.addControlChangeListener(listener);
    }

    @Override
    public void removeControlChangeListener(ControlChangeListener listener) {
        this.view.removeControlChangeListener(listener);
    }

    public void setPersistentService(PersistentService<T, ? extends Serializable> persistentService) {
        this.persistentService = persistentService;
        if (this.acceptAction instanceof PersistentServiceAware) {
            ((PersistentServiceAware)this.acceptAction).setPersistentService(this.persistentService);
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        public void windowClosing(WindowEvent e) {
            ViewFrame.this.cancelAction.actionPerformed(null);
        }
    }
}

