/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.Editor;
import info.joseluismartin.gui.EditorEvent;
import info.joseluismartin.gui.EditorListener;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.action.DialogAcceptAction;
import info.joseluismartin.gui.action.ViewAction;
import info.joseluismartin.gui.action.ViewCancelAction;
import info.joseluismartin.gui.bind.ControlChangeListener;
import info.joseluismartin.service.PersistentService;
import info.joseluismartin.service.PersistentServiceAware;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.springframework.validation.BindingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDialog<T>
extends JDialog
implements View<T>,
Editor<T> {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static final long serialVersionUID = 1L;
    private View<T> view;
    private ViewAction<T> acceptAction = new DialogAcceptAction();
    private ViewAction<T> cancelAction = new ViewCancelAction();
    private JButton acceptButton;
    private JButton cancelButton;
    private int windowWidth = 750;
    private int windowHeight = 750;
    private int value = 1;
    private PersistentService<T, ? extends Serializable> persistentService;
    private ArrayList<EditorListener> editorListeners = new ArrayList();

    public ViewDialog() {
        this((Frame)null);
    }

    public ViewDialog(Frame owner) {
        super(owner);
        this.acceptAction.setDialog(this);
        this.cancelAction.setDialog(this);
    }

    public void init() {
        this.acceptAction.setView(this.view);
        this.cancelAction.setView(this.view);
        this.add((Component)this.view.getPanel(), "Center");
        if (this.view.getModel() != null) {
            this.setTitle(this.view.getModel().toString());
        }
        this.add(this.createButtonBox(), "South");
        this.setSize(this.windowWidth, this.windowHeight);
        this.setLocationRelativeTo(null);
    }

    protected Component createButtonBox() {
        this.acceptButton = new JButton(this.acceptAction);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel p = new JPanel();
        p.add(this.acceptButton);
        p.add(this.cancelButton);
        return p;
    }

    public View<T> getView() {
        return this.view;
    }

    public void setView(View<T> view) {
        this.view = view;
    }

    public ViewAction<T> getAcceptAction() {
        return this.acceptAction;
    }

    public void setAcceptAction(ViewAction<T> acceptAction) {
        this.acceptAction = acceptAction;
        this.acceptAction.setView(this.view);
        this.acceptAction.setDialog(this);
    }

    public ViewAction<T> getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(ViewAction<T> cancelAction) {
        this.cancelAction = cancelAction;
        cancelAction.setView(this.view);
        cancelAction.setDialog(this);
    }

    public boolean isAccepted() {
        return this.value == 0;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Deprecated
    public int getDialogWidth() {
        return this.windowWidth;
    }

    @Deprecated
    public void setDialogWidth(int dialogWidth) {
        this.windowWidth = dialogWidth;
    }

    @Deprecated
    public int getDialogHeight() {
        return this.windowHeight;
    }

    @Deprecated
    public void setDialogHeight(int dialogHeight) {
        this.windowHeight = dialogHeight;
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public T getModel() {
        return this.view.getModel();
    }

    @Override
    public JComponent getPanel() {
        return this.view.getPanel();
    }

    @Override
    public void refresh() {
        if (this.view.getModel() != null) {
            this.setTitle(this.view.getModel().toString());
        }
        this.view.refresh();
    }

    @Override
    public void setModel(T model) {
        this.view.setModel(model);
    }

    @Override
    public void update() {
        this.view.update();
    }

    @Override
    public boolean validateView() {
        return this.view.validateView();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void enableView(boolean enabled) {
        this.view.enableView(enabled);
        this.acceptButton.setEnabled(enabled);
    }

    @Override
    public BindingResult getBindingResult() {
        return this.view.getBindingResult();
    }

    @Override
    public String getErrorMessage() {
        return this.view.getErrorMessage();
    }

    @Override
    public void addControlChangeListener(ControlChangeListener listener) {
        this.view.addControlChangeListener(listener);
    }

    @Override
    public void removeControlChangeListener(ControlChangeListener listener) {
        this.view.removeControlChangeListener(listener);
    }

    public void setPersistentService(PersistentService<T, ? extends Serializable> persistentService) {
        if (this.acceptAction instanceof PersistentServiceAware) {
            ((PersistentServiceAware)this.acceptAction).setPersistentService(persistentService);
        }
        this.persistentService = persistentService;
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        if (!this.editorListeners.contains(listener)) {
            this.editorListeners.add(listener);
        }
    }

    @Override
    public void save() {
        this.fireModelChanged();
    }

    private void fireModelChanged() {
        EditorEvent event = new EditorEvent(this, this.getModel());
        for (EditorListener listener : this.editorListeners) {
            listener.modelChanged(event);
        }
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.editorListeners.remove(listener);
    }

    public int getWindwoWidth() {
        return this.windowWidth;
    }

    public void setWindwoWidth(int windwoWidth) {
        this.windowWidth = windwoWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }
}

