/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class TitledSeparator
extends Box {
    public static final int BORDER = 0;
    public static final int BOLD = 1;
    public static final int NORMAL = 2;
    private Font font;
    private Color color;

    public TitledSeparator(String title) {
        this(title, 0);
    }

    public TitledSeparator(String title, int fontType) {
        super(2);
        this.font = TitledSeparator.getFont(fontType);
        if (fontType == 0) {
            this.color = UIManager.getColor("TitledBorder.titleColor");
        }
        this.build(title);
    }

    public TitledSeparator(String title, Font font, Color color) {
        super(2);
        this.font = font;
        this.color = color;
        this.build(title);
    }

    private void build(String title) {
        JLabel titleLabel = new JLabel(title);
        if (this.color != null) {
            titleLabel.setForeground(this.color);
        }
        titleLabel.setFont(this.font);
        titleLabel.setAlignmentY(1.0f);
        this.add(titleLabel);
        this.add(Box.createHorizontalStrut(5));
        JSeparator separator = new JSeparator();
        separator.setAlignmentY(0.0f);
        this.add(separator);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
    }

    private static Font getFont(int fontType) {
        Font font = null;
        switch (fontType) {
            case 0: {
                font = UIManager.getFont("TitledBorder.font");
                break;
            }
            case 1: 
            case 2: {
                return UIManager.getFont("Label.font").deriveFont(1);
            }
            default: {
                font = UIManager.getFont("Label.font");
            }
        }
        return font;
    }
}

