/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.beans.MessageSourceWrapper;
import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.IconAction;
import info.joseluismartin.gui.ListTableModel;
import info.joseluismartin.gui.action.BeanAction;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.service.PersistentService;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditor<T>
extends AbstractView<T>
implements TableModelListener {
    public static String DEFAULT_ICON = "/images/table/table.png";
    public static String DEFAULT_ADD_ICON = "/images/table/22x22/edit-new.png";
    public static String DEFAULT_REMOVE_ICON = "/images/table/22x22/edit-delete.png";
    public static String DEFAULT_SAVE_ICON = "/images/table/22x22/save.png";
    public static String DEFAULT_REFRESH_ICON = "/images/table/22x22/reload.png";
    private static final Log log = LogFactory.getLog(TableEditor.class);
    private JTable table;
    private ListTableModel tableModel;
    private Icon icon;
    private Icon addIcon;
    private Icon removeIcon;
    private Icon saveIcon;
    private Icon refreshIcon;
    private Set<T> dirty = new HashSet<T>();
    private Class<T> clazz;
    private String name;
    private PersistentService<T, Serializable> service;
    private MessageSourceWrapper messageSource = new MessageSourceWrapper();

    public TableEditor() {
    }

    public TableEditor(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void init() {
        this.loadIcons();
        if (this.tableModel.getModelClass() == null) {
            this.tableModel.setModelClass(this.clazz);
        }
        this.refresh();
    }

    @Override
    protected JComponent buildPanel() {
        Box box = Box.createVerticalBox();
        Container tablePanel = this.createTablePanel();
        box.add(tablePanel);
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return box;
    }

    protected Container createTablePanel() {
        this.table = new JTable(this.tableModel, this.tableModel.getTableColumnModel());
        this.table.setRowHeight(22);
        this.table.setAutoCreateRowSorter(true);
        this.tableModel.addTableModelListener(this);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        JButton addButton = new JButton(new AddAction());
        JButton deleteButton = new JButton(new DeleteAction());
        JButton saveButton = new JButton(new SaveAction());
        JButton refreshButton = new JButton(new RefreshAction());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(addButton);
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(deleteButton);
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(saveButton);
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(refreshButton);
        buttonBox.setAlignmentX(0.0f);
        buttonBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        box.add(buttonBox);
        box.add(Box.createVerticalStrut(5));
        box.add(scroll);
        return box;
    }

    @Override
    public void doRefresh() {
        this.tableModel.setList(this.service.getAll());
    }

    protected Container createHeader() {
        JLabel label = new JLabel(this.getName());
        label.setAlignmentX(0.0f);
        Box box = Box.createHorizontalBox();
        box.add(label);
        return box;
    }

    public void add() {
        T t = this.newType();
        this.tableModel.add(t);
        this.dirty.add(t);
    }

    public void delete() {
        int[] rows;
        for (int i : rows = this.table.getSelectedRows()) {
            Object model = this.tableModel.getList().get(this.table.convertRowIndexToModel(i));
            try {
                this.service.delete(model);
                this.tableModel.getList().remove(model);
            }
            catch (DataAccessException dae) {
                String errorMsg = this.messageSource.getMessage("TableEditor.objectInUse", new Object[]{model.toString()}, Locale.getDefault());
                JOptionPane.showMessageDialog(this.getPanel(), errorMsg, "Error", 0);
            }
        }
        this.tableModel.fireTableChanged();
    }

    private T newType() {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Can't instantiate class: ", (Throwable)e);
            return null;
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public ListTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(ListTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public Icon getAddIcon() {
        return this.addIcon;
    }

    public void setAddIcon(Icon addIcon) {
        this.addIcon = addIcon;
    }

    public PersistentService<T, Serializable> getService() {
        return this.service;
    }

    public void setService(PersistentService<T, Serializable> service) {
        this.service = service;
    }

    public Icon getSaveIcon() {
        return this.saveIcon;
    }

    public void setSaveIcon(Icon saveIcon) {
        this.saveIcon = saveIcon;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row;
        if (e.getType() == 0 && (row = e.getFirstRow()) >= 0) {
            this.dirty.add(this.tableModel.getList().get(row));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected void loadIcons() {
        this.icon = FormUtils.getIcon(this.icon, DEFAULT_ICON);
        this.addIcon = FormUtils.getIcon(this.addIcon, DEFAULT_ADD_ICON);
        this.saveIcon = FormUtils.getIcon(this.saveIcon, DEFAULT_SAVE_ICON);
        this.removeIcon = FormUtils.getIcon(this.removeIcon, DEFAULT_REMOVE_ICON);
        this.refreshIcon = FormUtils.getIcon(this.refreshIcon, DEFAULT_REFRESH_ICON);
    }

    public Icon getRemoveIcon() {
        return this.removeIcon;
    }

    public void setRemoveIcon(Icon removeIcon) {
        this.removeIcon = removeIcon;
    }

    public Icon getRefreshIcon() {
        return this.refreshIcon;
    }

    public void setRefreshIcon(Icon refreshIcon) {
        this.refreshIcon = refreshIcon;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource.getMessageSource();
    }

    @Override
    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource.setMessageSource(messageSource);
    }

    private class RefreshAction
    extends BeanAction {
        private static final long serialVersionUID = 1L;

        public RefreshAction() {
            this.setIcon(TableEditor.this.refreshIcon);
        }

        public void actionPerformed(ActionEvent e) {
            TableEditor.this.dirty.clear();
            TableEditor.this.refresh();
        }
    }

    private class DeleteAction
    extends IconAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction() {
            this.setIcon(TableEditor.this.removeIcon);
        }

        public void actionPerformed(ActionEvent e) {
            TableEditor.this.delete();
        }
    }

    private class AddAction
    extends IconAction {
        private static final long serialVersionUID = 1L;

        public AddAction() {
            this.setIcon(TableEditor.this.addIcon);
        }

        public void actionPerformed(ActionEvent e) {
            TableEditor.this.add();
        }
    }

    private class SaveAction
    extends IconAction {
        private static final long serialVersionUID = 1L;

        public SaveAction() {
            this.setIcon(TableEditor.this.saveIcon);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TableEditor.this.service.save((Collection)TableEditor.this.dirty);
            }
            catch (DataAccessException dae) {
                String errorMsg = TableEditor.this.messageSource.getMessage("TableEditor.saveError", null, Locale.getDefault());
                JOptionPane.showMessageDialog(TableEditor.this.getPanel(), errorMsg, "Error", 0);
            }
            TableEditor.this.refresh();
        }
    }
}

