/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.ApplicationContextGuiFactory;
import info.joseluismartin.gui.form.BoxFormBuilder;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.list.ListListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector<T>
extends JPanel {
    private String name;
    private ListListModel available = new ListListModel();
    private ListListModel selected = new ListListModel();
    private List<T> all = new ArrayList<T>();
    private JList availableList;
    private JList selectedList;
    private JTextField availableSearch = new JTextField();
    private JTextField selectedSearch = new JTextField();
    private Icon rightArrow = FormUtils.getIcon("images/button_right.png");
    private Icon leftArrow = FormUtils.getIcon("images/button_left.png");
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean firingActionEvent = false;
    @Autowired
    private MessageSource messageSource;
    private int buttonWidth = 30;
    private int buttonHeight = 30;
    private int listWidth = 300;
    private int listheight = 100;
    private boolean showSearchFields = false;

    public Selector() {
    }

    public Selector(List<T> all) {
        this(all, new ArrayList());
        this.all = all;
    }

    public Selector(List<T> available, List<T> selected) {
        this.available = new ListListModel(available);
        this.selected = new ListListModel(selected);
        this.all.addAll(available);
        this.all.addAll(selected);
    }

    public void init() {
        this.availableList = new JList(this.available);
        this.selectedList = new JList(this.selected);
        this.availableSearch.setVisible(this.showSearchFields);
        this.selectedSearch.setVisible(this.showSearchFields);
        JButton addButton = new JButton(new AddSelectedAction());
        JButton removeButton = new JButton(new RemoveSelectedAction());
        addButton.setMinimumSize(new Dimension(this.buttonWidth, this.buttonHeight));
        removeButton.setMinimumSize(new Dimension(this.buttonWidth, this.buttonHeight));
        JScrollPane availableScroll = new JScrollPane(this.availableList);
        JScrollPane selectedScroll = new JScrollPane(this.selectedList);
        availableScroll.setPreferredSize(new Dimension(this.listWidth, this.listheight));
        selectedScroll.setPreferredSize(new Dimension(this.listWidth, this.listheight));
        availableScroll.setMinimumSize(new Dimension(this.listWidth, this.listheight));
        selectedScroll.setMinimumSize(new Dimension(this.listWidth, this.listheight));
        if (this.messageSource == null) {
            this.messageSource = new ResourceBundleMessageSource();
            ((ResourceBundleMessageSource)this.messageSource).setBasename("i18n.jdal");
        }
        MessageSourceAccessor msa = new MessageSourceAccessor(this.messageSource);
        BoxFormBuilder fb = new BoxFormBuilder();
        fb.row(Short.MAX_VALUE);
        fb.startBox();
        fb.row();
        fb.add(this.availableSearch);
        fb.row();
        fb.add(FormUtils.newLabelForBox(msa.getMessage("Selector.available")));
        fb.row(Short.MAX_VALUE);
        fb.add(availableScroll);
        fb.endBox();
        fb.startBox();
        fb.row(Short.MAX_VALUE);
        fb.add(Box.createVerticalGlue());
        fb.row(this.buttonHeight);
        fb.add(removeButton);
        fb.row(Short.MAX_VALUE);
        fb.add(Box.createVerticalGlue());
        fb.endBox();
        fb.setMaxWidth(this.buttonWidth);
        fb.startBox();
        fb.row(Short.MAX_VALUE);
        fb.add(Box.createVerticalGlue());
        fb.row(this.buttonHeight);
        fb.add(addButton);
        fb.row(Short.MAX_VALUE);
        fb.add(Box.createVerticalGlue());
        fb.endBox();
        fb.setMaxWidth(this.buttonWidth);
        fb.startBox();
        fb.row();
        fb.add(this.selectedSearch);
        fb.row();
        fb.add(FormUtils.newLabelForBox(msa.getMessage("Selector.selected")));
        fb.row(Short.MAX_VALUE);
        fb.add(selectedScroll);
        fb.endBox();
        this.setLayout(new BorderLayout());
        this.add((Component)fb.getForm(), "Center");
    }

    private void addSelected() {
        Object[] selectedValues = this.availableList.getSelectedValues();
        if (selectedValues.length > 0) {
            ListListModel availableModel = (ListListModel)this.availableList.getModel();
            availableModel.removeAll(Arrays.asList(selectedValues));
            ListListModel selectedModel = (ListListModel)this.selectedList.getModel();
            selectedModel.addAll(Arrays.asList(selectedValues));
            this.clearSelections();
            this.fireActionEvent();
        }
    }

    private void clearSelections() {
        this.availableList.clearSelection();
        this.selectedList.clearSelection();
    }

    private void removeSelected() {
        Object[] selectedValues = this.selectedList.getSelectedValues();
        if (selectedValues.length > 0) {
            ListListModel selectedModel = (ListListModel)this.selectedList.getModel();
            selectedModel.removeAll(Arrays.asList(selectedValues));
            ListListModel availableModel = (ListListModel)this.availableList.getModel();
            availableModel.addAll(Arrays.asList(selectedValues));
            this.clearSelections();
            this.fireActionEvent();
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent event = new ActionEvent(this, 1001, "selectorChanged");
            for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
                listener.actionPerformed(event);
            }
            this.firingActionEvent = false;
        }
    }

    public List<T> getAvailable() {
        return this.available.getList();
    }

    public void setAvailable(List<T> available) {
        this.available.clear();
        this.available.addAll(available);
        ArrayList<T> l = new ArrayList<T>(this.all);
        l.removeAll(available);
        this.selected.clear();
        this.selected.addAll(l);
    }

    public List<T> getSelected() {
        return this.selected.getList();
    }

    public void setSelected(List<T> selected) {
        this.selected.clear();
        this.available.clear();
        this.available.addAll(this.all);
        if (selected != null) {
            this.selected.addAll(selected);
            this.available.removeAll(selected);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Icon getRightArrow() {
        return this.rightArrow;
    }

    public void setRightArrow(Icon rightArrow) {
        this.rightArrow = rightArrow;
    }

    public Icon getLeftArrow() {
        return this.leftArrow;
    }

    public void setLeftArrow(Icon leftArrow) {
        this.leftArrow = leftArrow;
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListner(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public List<T> getAll() {
        return this.all;
    }

    public void setAll(List<T> all) {
        this.all = all;
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth = buttonWidth;
    }

    public int getButtonHeight() {
        return this.buttonHeight;
    }

    public void setButtonHeight(int buttonHeight) {
        this.buttonHeight = buttonHeight;
    }

    public boolean isShowSearchFields() {
        return this.showSearchFields;
    }

    public void setShowSearchFields(boolean showSearchFields) {
        this.showSearchFields = showSearchFields;
    }

    public static void main(String[] args) {
        ApplicationContextGuiFactory.setPlasticLookAndFeel();
        Selector<Object> selector = new Selector<Object>();
        selector.setAvailable(Arrays.asList("lala"));
        selector.init();
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.add(selector);
        f.setSize(800, 800);
        f.setVisible(true);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public int getListWidth() {
        return this.listWidth;
    }

    public void setListWidth(int listWidth) {
        this.listWidth = listWidth;
    }

    public int getListheight() {
        return this.listheight;
    }

    public void setListheight(int listheight) {
        this.listheight = listheight;
    }

    private class RemoveSelectedAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RemoveSelectedAction() {
            this.putValue("SmallIcon", Selector.this.leftArrow);
        }

        public void actionPerformed(ActionEvent e) {
            Selector.this.removeSelected();
        }
    }

    private class AddSelectedAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddSelectedAction() {
            this.putValue("SmallIcon", Selector.this.rightArrow);
        }

        public void actionPerformed(ActionEvent e) {
            Selector.this.addSelected();
        }
    }
}

