/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRowSorter<M extends TableModel>
extends RowSorter<M> {
    private M model;
    private List<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();

    public ModelRowSorter(M tableModel) {
        this.model = tableModel;
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return index;
    }

    @Override
    public int convertRowIndexToView(int index) {
        return index;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public int getModelRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public int getViewRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }

    @Override
    public void toggleSortOrder(int column) {
        ArrayList<RowSorter.SortKey> newKeys = new ArrayList<RowSorter.SortKey>(1);
        if (this.sortKeys.size() > 0) {
            RowSorter.SortKey key = this.sortKeys.get(0);
            if (key.getColumn() == column) {
                newKeys.add(0, this.toggle(key));
            } else {
                newKeys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
            }
        } else {
            newKeys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
        }
        this.setSortKeys(newKeys);
    }

    public void setModel(M model) {
        this.model = model;
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        this.sortKeys.clear();
        this.sortKeys.addAll(sortKeys);
        this.fireSortOrderChanged();
    }

    private RowSorter.SortKey toggle(RowSorter.SortKey key) {
        if (key.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
        }
        return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
    }
}

