/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.beans.MessageSourceWrapper;
import info.joseluismartin.gui.ActionCellRenderer;
import info.joseluismartin.gui.ColumnDefinition;
import info.joseluismartin.gui.table.AnnotationFormatTableCellRenderer;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTableModel
implements TableModel {
    public static final String MAX_WIDTH = "maxWidth";
    public static final String CELL_RENDERER = "cellRenderer";
    private static final String CELL_EDITOR = "cellEditor";
    private static final Log log = LogFactory.getLog(ListTableModel.class);
    private List list;
    private ArrayList<TableModelListener> listeners = new ArrayList();
    private int columnCount = 0;
    private List<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
    private List<String> columnNames = new ArrayList<String>();
    private List<String> displayNames = new ArrayList<String>();
    private boolean usingIntrospection = false;
    private boolean usingChecks = true;
    private boolean usingActions = false;
    private List<Action> actions = new ArrayList<Action>();
    private List<Boolean> checks = new ArrayList<Boolean>();
    private Map<String, Boolean> editableMap = new HashMap<String, Boolean>();
    private Set<Serializable> selectedRowSet = new HashSet<Serializable>();
    private String id = "id";
    private Class modelClass;
    private List<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
    private TableCellRenderer defaultTableCellRenderer = new AnnotationFormatTableCellRenderer();
    private MessageSourceWrapper messageSource = new MessageSourceWrapper();

    public ListTableModel(List l) {
        this.setList(l);
    }

    public ListTableModel() {
        this.setList(new ArrayList());
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = "";
        if (this.isPropertyColumn(columnIndex)) {
            name = this.messageSource.getMessage(this.displayNames.get(this.columnToPropertyIndex(columnIndex)));
        }
        return name;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class clazz = Object.class;
        if (this.isCheckColum(columnIndex)) {
            clazz = Boolean.class;
        } else if (this.isPropertyColumn(columnIndex)) {
            if (this.pds.size() > 0) {
                clazz = this.pds.get(this.columnToPropertyIndex(columnIndex)).getPropertyType();
            }
        } else if (this.isActionColumn(columnIndex)) {
            clazz = this.actions.get(this.columntoToActionIndex(columnIndex)).getClass();
        }
        return ClassUtils.resolvePrimitiveIfNecessary(clazz);
    }

    private int columntoToActionIndex(int columnIndex) {
        return columnIndex - this.pds.size() - (this.usingChecks ? 1 : 0);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isCheckColum(columnIndex) || this.isActionColumn(columnIndex) || this.isPropertyColumn(columnIndex) && Boolean.TRUE.equals(this.editableMap.get(this.getPropertyName(columnIndex)));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.usingChecks) {
            if (columnIndex == 0) {
                this.fillChecksIfNecesary(rowIndex);
                return this.checks.get(rowIndex);
            }
            --columnIndex;
        }
        if (columnIndex < this.pds.size()) {
            return this.getCellValue(rowIndex, columnIndex);
        }
        if (this.usingActions) {
            return this.actions.get(columnIndex - this.pds.size());
        }
        return null;
    }

    private void fillChecksIfNecesary(int rowIndex) {
        if (this.checks.size() >= rowIndex) {
            for (int i = this.checks.size() - 1; i < rowIndex; ++i) {
                this.checks.add(Boolean.FALSE);
            }
        }
    }

    private Object getCellValue(int rowIndex, int columnIndex) {
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(this.list.get(rowIndex));
        return bw.getPropertyValue(this.columnNames.get(columnIndex));
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.isCheckColum(columnIndex)) {
            this.checks.set(rowIndex, (Boolean)value);
            Object row = this.list.get(rowIndex);
            if (Boolean.TRUE.equals(value)) {
                this.selectedRowSet.add((Serializable)this.getPrimaryKey(row));
            } else {
                this.selectedRowSet.remove(this.getPrimaryKey(row));
            }
        } else if (this.isPropertyColumn(columnIndex)) {
            int index = this.columnToPropertyIndex(columnIndex);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(this.list.get(rowIndex));
            bw.setPropertyValue(this.columnNames.get(index), value);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void init() {
        if (this.modelClass == null) {
            log.warn((Object)"Cannot initilize without  modelClass, set a list of models o specify a model class");
            return;
        }
        this.columnCount = 0;
        if (this.usingIntrospection) {
            this.pds = Arrays.asList(BeanUtils.getPropertyDescriptors((Class)this.modelClass));
            Collections.reverse(this.pds);
            this.columnNames = new ArrayList<String>(this.pds.size());
            this.displayNames = new ArrayList<String>(this.pds.size());
            for (PropertyDescriptor propertyDescriptor : this.pds) {
                this.columnNames.add(propertyDescriptor.getName());
                this.displayNames.add(propertyDescriptor.getDisplayName());
            }
        } else {
            this.pds = new ArrayList<PropertyDescriptor>(this.columnNames.size());
            for (String name : this.columnNames) {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor((Class)this.modelClass, (String)name);
                if (pd == null) {
                    throw new RuntimeException("Invalid property [" + name + "]" + " for model class [" + this.modelClass.getName() + "]");
                }
                this.pds.add(pd);
            }
        }
        this.columnCount += this.pds.size();
        if (this.usingChecks) {
            ++this.columnCount;
            this.buildCheckArray();
        }
        if (this.usingActions) {
            this.columnCount += this.actions.size();
        }
    }

    private void buildCheckArray() {
        this.checks = new ArrayList<Boolean>(this.list.size());
        for (Object row : this.list) {
            this.checks.add(this.selectedRowSet.contains(this.getPrimaryKey(row)));
        }
    }

    public void fireTableChanged(TableModelEvent e) {
        Iterator<TableModelListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().tableChanged(e);
        }
    }

    public TableColumnModel getTableColumnModel() {
        TableColumn tableColumn;
        int i;
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        int baseIndex = 0;
        if (this.usingChecks) {
            TableColumn tableColumn2 = new TableColumn(0);
            tableColumn2.setMaxWidth(50);
            tcm.addColumn(tableColumn2);
            ++baseIndex;
        }
        for (i = 0; i < this.columnNames.size(); ++i) {
            PropertyDescriptor descriptor;
            tableColumn = new TableColumn(baseIndex + i);
            tableColumn.setHeaderValue(this.displayNames.get(i));
            if (this.pds != null && this.pds.size() > 0 && (descriptor = this.pds.get(i)) != null) {
                Integer maxWidth = this.getColumnWidth(i);
                if (maxWidth != null) {
                    tableColumn.setMaxWidth(maxWidth);
                }
                tableColumn.setCellRenderer(this.getColumnRenderer(i));
                tableColumn.setCellEditor(this.getColumnEditor(i));
            }
            tcm.addColumn(tableColumn);
        }
        if (this.usingActions) {
            baseIndex += this.columnNames.size();
            for (i = 0; i < this.actions.size(); ++i) {
                tableColumn = new TableColumn(baseIndex + i);
                tableColumn.setCellRenderer(new ActionCellRenderer());
                tableColumn.setMaxWidth(50);
                tcm.addColumn(tableColumn);
            }
        }
        return tcm;
    }

    private TableCellRenderer getColumnRenderer(int index) {
        TableCellRenderer renderer = (TableCellRenderer)this.pds.get(index).getValue(CELL_RENDERER);
        if (renderer == null && this.columns.size() > 0) {
            renderer = this.columns.get(index).getRenderer();
        }
        if (renderer == null) {
            renderer = this.defaultTableCellRenderer;
        }
        return renderer;
    }

    private TableCellEditor getColumnEditor(int index) {
        TableCellEditor editor = (TableCellEditor)this.pds.get(index).getValue(CELL_EDITOR);
        if (editor == null && this.columns.size() > 0) {
            editor = this.columns.get(index).getEditor();
        }
        return editor;
    }

    private Integer getColumnWidth(int index) {
        Integer maxWidth = (Integer)this.pds.get(index).getValue(MAX_WIDTH);
        if (maxWidth == null && this.columns.size() > 0) {
            maxWidth = this.columns.get(index).getWidth();
        }
        return maxWidth;
    }

    public boolean add(Object o) {
        boolean result = this.list.add(o);
        if (this.usingChecks) {
            this.checks.add(Boolean.FALSE);
        }
        if (this.list.size() == 1) {
            this.init();
        }
        this.fireTableChanged(new TableModelEvent(this, this.list.size() - 1, this.list.size() - 1, -1, 1));
        return result;
    }

    public Object remove(int index) {
        Object result = this.list.remove(index);
        this.fireTableChanged(new TableModelEvent(this, index, index, -1, -1));
        return result;
    }

    public boolean isPropertyColumn(int column) {
        if (this.usingChecks) {
            return column > 0 && column <= this.columnNames.size();
        }
        return column < this.columnNames.size();
    }

    public boolean isCheckColum(int column) {
        return this.usingChecks && column == 0;
    }

    public boolean isActionColumn(int column) {
        return !this.isPropertyColumn(column) && !this.isCheckColum(column);
    }

    public String getPropertyName(int index) {
        if (this.isPropertyColumn(index)) {
            return this.columnNames.get(this.columnToPropertyIndex(index));
        }
        return null;
    }

    private int getColumnByPropertyName(String propertyName) {
        int i = 0;
        for (String columnName : this.columnNames) {
            if (columnName.equals(propertyName)) {
                return this.isUsingChecks() ? i + 1 : i;
            }
            ++i;
        }
        return -1;
    }

    public int columnToPropertyIndex(int column) {
        return this.usingChecks ? column - 1 : column;
    }

    public void fireTableChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void setColumnEditable(int columnIndex, boolean value) {
        if (this.isPropertyColumn(columnIndex)) {
            this.editableMap.put(this.getPropertyName(columnIndex), value);
        }
    }

    public void setEditableMap(Map<String, Boolean> editableMap) {
        this.editableMap = editableMap;
    }

    public void setList(List list) {
        boolean modelClassChanged;
        this.list = list;
        boolean initilized = this.pds.size() > 0;
        boolean bl = modelClassChanged = list.size() > 0 && !list.get(0).getClass().equals(this.modelClass);
        if (!initilized || modelClassChanged) {
            if (modelClassChanged) {
                this.modelClass = list.get(0).getClass();
            }
            this.init();
        }
        if (this.usingChecks) {
            this.buildCheckArray();
        }
        this.fireTableChanged();
    }

    public List getList() {
        return this.list;
    }

    public Iterator<?> iterator() {
        return this.list.iterator();
    }

    public boolean isUsingIntrospection() {
        return this.usingIntrospection;
    }

    public void setUsingIntrospection(boolean usingIntrospection) {
        this.usingIntrospection = usingIntrospection;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getPropertyCount() {
        return this.columnNames.size();
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.setColumnNames(Arrays.asList(columnNames));
    }

    public List<String> getDisplayNames() {
        return this.displayNames;
    }

    public void setDisplayNames(List<String> displayNames) {
        this.displayNames = displayNames;
    }

    public void setDisplayNames(String[] displayNames) {
        this.setDisplayNames(Arrays.asList(displayNames));
    }

    public boolean isUsingChecks() {
        return this.usingChecks;
    }

    public void setUsingChecks(boolean useChecks) {
        this.usingChecks = useChecks;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean isUsingActions() {
        return this.usingActions;
    }

    public void setUsingActions(boolean useActions) {
        this.usingActions = useActions;
    }

    public Map<String, Boolean> getEditableMap() {
        return this.editableMap;
    }

    private Object getPrimaryKey(Object row) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)row);
        return wrapper.getPropertyValue(this.id);
    }

    public void check(List<Serializable> keys) {
        if (this.usingChecks) {
            this.selectedRowSet.addAll(keys);
            this.fillChecks(true);
        }
    }

    public List<Serializable> getChecked() {
        return new ArrayList<Serializable>(this.selectedRowSet);
    }

    public List getVisibleChecked() {
        ArrayList visibleChecked = new ArrayList();
        for (int i = 0; i < this.checks.size(); ++i) {
            if (!this.checks.get(i).booleanValue()) continue;
            visibleChecked.add(this.list.get(i));
        }
        return visibleChecked;
    }

    public void uncheckAll() {
        if (this.usingChecks) {
            this.selectedRowSet.clear();
            this.fillChecks(false);
        }
    }

    private void fillChecks(boolean value) {
        for (int i = 0; i < this.checks.size(); ++i) {
            this.checks.set(i, value);
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.list.size() - 1));
    }

    public void addAction(Action action) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
        }
    }

    public Class getModelClass() {
        return this.modelClass;
    }

    public void setModelClass(Class modelClass) {
        this.modelClass = modelClass;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
        this.parseColumnDefinitions();
    }

    private void parseColumnDefinitions() {
        this.displayNames.clear();
        this.columnNames.clear();
        this.editableMap.clear();
        for (ColumnDefinition cd : this.columns) {
            this.columnNames.add(cd.getName());
            this.displayNames.add(cd.getDisplayName());
            this.editableMap.put(cd.getName(), cd.isEditable());
        }
    }

    public TableCellRenderer getDefaultTableCellRenderer() {
        return this.defaultTableCellRenderer;
    }

    public void setDefaultTableCellRenderer(TableCellRenderer defaultTableCellRenderer) {
        this.defaultTableCellRenderer = defaultTableCellRenderer;
    }

    public String getSortPropertyName(int column) {
        String sortPropertyName = null;
        if (this.isPropertyColumn(column)) {
            if (this.columns.size() > column) {
                sortPropertyName = this.columns.get(this.columnToPropertyIndex(column)).getSortProperty();
            }
            if (sortPropertyName == null) {
                sortPropertyName = this.getPropertyName(column);
            }
        }
        return sortPropertyName;
    }

    public MessageSource getMessageSource() {
        return this.messageSource.getMessageSource();
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource.setMessageSource(messageSource);
    }

    public void checkAll() {
        this.fillChecks(true);
    }

    public void removeAll(Collection toRemove) {
        this.list.removeAll(toRemove);
        this.fireTableChanged();
    }

    public void remove(Object toRemove) {
        if (toRemove != null) {
            this.list.remove(toRemove);
        }
    }
}

