/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import info.joseluismartin.gui.GuiFactory;
import info.joseluismartin.gui.View;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ColorUIResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContextGuiFactory
implements GuiFactory,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(ApplicationContextGuiFactory.class);
    protected ApplicationContext context;

    @Override
    public JComponent getComponent(String name) {
        Object bean = this.context.getBean(name);
        if (bean instanceof JComponent) {
            return (JComponent)bean;
        }
        return null;
    }

    @Override
    public JDialog getDialog(String name) {
        Object bean = this.context.getBean(name);
        if (bean instanceof JDialog) {
            return (JDialog)bean;
        }
        return null;
    }

    @Override
    public Object getObject(String name) {
        return this.context.getBean(name);
    }

    @Override
    public JPanel getPanel(String name) {
        Object bean = this.context.getBean(name);
        if (bean instanceof JPanel) {
            return (JPanel)bean;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    @Override
    public View<?> getView(String name) {
        Object bean = this.context.getBean(name);
        return bean != null ? (View)bean : null;
    }

    @Override
    public Object getObject(String name, Object[] args) {
        return this.context.getBean(name, args);
    }

    public static JFrame getJFrame() {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(new Dimension(800, 600));
        return f;
    }

    public static void setPlasticLookAndFeel() {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            UIManager.put("Table.gridColor", new ColorUIResource(Color.GRAY));
            UIManager.put("TableHeader.background", new ColorUIResource(220, 220, 220));
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)e);
        }
    }

    @Deprecated
    public static Border createTitledBorder(String name) {
        Border margin = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder title = BorderFactory.createTitledBorder(name);
        return BorderFactory.createCompoundBorder(title, margin);
    }
}

