/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.Binder;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.bind.BinderFactory;
import info.joseluismartin.gui.bind.BinderHolder;
import info.joseluismartin.gui.bind.CompositeBinder;
import info.joseluismartin.gui.bind.ConfigurableBinderFactory;
import info.joseluismartin.gui.bind.ConfigurableControlAccessorFactory;
import info.joseluismartin.gui.bind.ControlAccessor;
import info.joseluismartin.gui.bind.ControlAccessorFactory;
import info.joseluismartin.gui.bind.ControlChangeListener;
import info.joseluismartin.gui.bind.ControlError;
import info.joseluismartin.gui.bind.ControlEvent;
import info.joseluismartin.gui.bind.ControlInitializer;
import info.joseluismartin.gui.bind.DirectFieldAccessor;
import info.joseluismartin.gui.bind.PropertyBinder;
import info.joseluismartin.gui.validation.ErrorProcessor;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractView<T>
implements View<T>,
ControlChangeListener,
BinderHolder {
    public static final String DEFAULT_BINDER_FACTORY_NAME = "binderFactory";
    private static final Log log = LogFactory.getLog(AbstractView.class);
    private String name;
    private BinderFactory binderFactory;
    private ControlAccessorFactory controlAccessorFactory;
    private CompositeBinder<T> binder = new CompositeBinder();
    private boolean autobinding = false;
    private Set<String> ignoredProperties = new HashSet<String>();
    private T model;
    private JComponent panel;
    private List<View> subViews = new ArrayList<View>();
    private Validator validator;
    @Autowired
    protected MessageSource messageSource;
    private List<ErrorProcessor> errorProcessors = new ArrayList<ErrorProcessor>();
    protected BindingResult errors;
    private boolean dirty = false;
    private boolean initializeControls = true;
    protected int width = 0;
    protected int height = 0;
    private ControlInitializer controlInitializer;
    private List<ControlChangeListener> listeners = new ArrayList<ControlChangeListener>();

    public AbstractView() {
        this(null);
    }

    public AbstractView(T model) {
        this.setModel(model);
    }

    public void bind(Object component, String propertyName, boolean readOnly) {
        this.checkFactories();
        this.binder.bind(component, propertyName, readOnly);
        this.listen(component);
    }

    private void checkFactories() {
        if (this.controlAccessorFactory == null) {
            this.setControlAccessorFactory(ConfigurableControlAccessorFactory.getDefaultFactory());
        }
        if (this.binderFactory == null) {
            this.setBinderFactory(ConfigurableBinderFactory.getDefaultFactory());
        }
    }

    public void bind(Object component, String propertyName) {
        this.bind(component, propertyName, false);
    }

    @Override
    public JComponent getPanel() {
        if (this.panel == null) {
            this.panel = this.buildPanel();
            if (this.width != 0 && this.height != 0) {
                this.panel.setSize(this.width, this.height);
            }
        }
        return this.panel;
    }

    protected abstract JComponent buildPanel();

    @Override
    public T getModel() {
        return this.model;
    }

    @Override
    public final void setModel(T model) {
        this.model = model;
        this.createBindingResult();
        this.binder.setModel(model);
        for (View v : this.subViews) {
            v.setModel(model);
        }
        this.onSetModel(model);
    }

    private void createBindingResult() {
        if (this.model != null) {
            this.errors = new BeanPropertyBindingResult(this.getModel(), this.getModel().getClass().getSimpleName());
        }
    }

    protected void onSetModel(T model) {
    }

    @Override
    public final void update() {
        this.clearErrors();
        this.doUpdate();
        this.binder.update();
        if (this.errors != null && this.binder.getBindingResult() != null && this.errors.getObjectName().equals(this.binder.getBindingResult().getObjectName())) {
            this.errors.addAllErrors((Errors)this.binder.getBindingResult());
        }
        for (View v : this.subViews) {
            v.update();
            if (this.errors == null || v.getBindingResult() == null || !this.errors.getObjectName().equals(v.getBindingResult().getObjectName())) continue;
            this.errors.addAllErrors((Errors)v.getBindingResult());
        }
        this.afterUpdate();
    }

    private void clearErrors() {
        if (this.getModel() != null && this.errors != null && this.errors.hasErrors()) {
            this.createBindingResult();
        }
        this.resetErrorProcessors();
    }

    protected void doUpdate() {
    }

    protected void afterUpdate() {
    }

    public void addView(View view) {
        this.subViews.add(view);
        view.setModel(this.model);
    }

    @Override
    public final void refresh() {
        this.clearErrors();
        this.doRefresh();
        this.binder.refresh();
        for (View v : this.subViews) {
            v.refresh();
        }
        this.setDirty(false);
    }

    protected void doRefresh() {
    }

    protected void afterRefresh() {
    }

    public void listen(Object control) {
        this.checkFactories();
        ControlAccessor c = this.controlAccessorFactory.getControlAccessor(control);
        if (c != null) {
            c.addControlChangeListener(this);
        }
    }

    @Override
    public void controlChange(ControlEvent e) {
        this.setDirty(true);
        this.fireControlChange(e);
    }

    public BinderFactory getBinderFactory() {
        return this.binderFactory;
    }

    public void setBinderFactory(BinderFactory binderFactory) {
        this.binderFactory = binderFactory;
        this.binder.setBinderFactory(binderFactory);
    }

    @Override
    public boolean validateView() {
        if (this.validator == null && !this.errors.hasErrors()) {
            return true;
        }
        if (this.validator != null) {
            this.validator.validate(this.getModel(), (Errors)this.errors);
        }
        if (this.errors.hasErrors()) {
            for (FieldError error : this.errors.getFieldErrors()) {
                for (ErrorProcessor ep : this.errorProcessors) {
                    if (error instanceof ControlError) {
                        ControlError ce = (ControlError)error;
                        ep.processError(ce.getComponent(), error);
                        continue;
                    }
                    PropertyBinder b = this.binder.getBinder(error.getField());
                    if (!(b instanceof PropertyBinder)) continue;
                    ep.processError(b.getComponent(), error);
                }
            }
            return false;
        }
        return true;
    }

    private void resetErrorProcessors() {
        for (ErrorProcessor ep : this.errorProcessors) {
            ep.reset();
        }
    }

    @Override
    public String getErrorMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.errors.hasErrors()) {
            sb.append("\n");
            for (ObjectError oe : this.errors.getAllErrors()) {
                sb.append("- ");
                sb.append(this.getMessage((MessageSourceResolvable)oe));
                sb.append("\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void clear() {
        T model = this.getModel();
        if (model != null) {
            try {
                this.setModel(model.getClass().newInstance());
                this.refresh();
            }
            catch (InstantiationException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    public void enableView(boolean enabled) {
        for (Binder<T> b : this.binder.getPropertyBinders()) {
            Object control = ((PropertyBinder)b).getComponent();
            if (control instanceof Component) {
                ((Component)control).setEnabled(enabled);
            } else if (control instanceof View) {
                ((View)control).enableView(enabled);
            }
            for (View v : this.subViews) {
                v.enableView(enabled);
            }
        }
    }

    public void autobind() {
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(this.getModel());
        DirectFieldAccessor viewPropertyAccessor = new DirectFieldAccessor(this);
        for (PropertyDescriptor pd : bw.getPropertyDescriptors()) {
            Object control;
            String propertyName = pd.getName();
            if (this.ignoredProperties.contains(propertyName) || !viewPropertyAccessor.isReadableProperty(propertyName) || (control = viewPropertyAccessor.getPropertyValue(propertyName)) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found control: " + control.getClass().getSimpleName() + " for property: " + propertyName));
            }
            this.bind(control, propertyName);
            if (!this.isInitializeControls() || this.controlInitializer == null) continue;
            this.controlInitializer.initialize(control, propertyName, this.getModel().getClass());
        }
    }

    protected String getMessage(String code) {
        try {
            return this.messageSource == null ? code : this.messageSource.getMessage(code, null, Locale.getDefault());
        }
        catch (NoSuchMessageException nsme) {
            log.error((Object)nsme);
            return code;
        }
    }

    protected String getMessage(MessageSourceResolvable msr) {
        return this.messageSource == null ? msr.getDefaultMessage() : this.messageSource.getMessage(msr, Locale.getDefault());
    }

    @Override
    public void addControlChangeListener(ControlChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeControlChangeListener(ControlChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    protected void fireControlChange(ControlEvent e) {
        for (ControlChangeListener l : this.listeners) {
            l.controlChange(new ControlEvent(e));
        }
    }

    public void ignoreProperty(String propertyName) {
        this.ignoredProperties.add(propertyName);
    }

    public Set<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public void setIgnoredProperties(Set<String> ignoredProperties) {
        this.ignoredProperties = ignoredProperties;
    }

    public void ignoreProperties(Collection<? extends String> c) {
        this.ignoredProperties.addAll(c);
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ErrorProcessor> getErrorProcessors() {
        return this.errorProcessors;
    }

    public void setErrorProcessors(List<ErrorProcessor> errorProcessors) {
        this.errorProcessors = errorProcessors;
    }

    @Override
    public boolean isDirty() {
        boolean d = this.dirty;
        for (View v : this.subViews) {
            d = d || v.isDirty();
        }
        return d;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public ControlAccessorFactory getControlAccessorFactory() {
        return this.controlAccessorFactory;
    }

    public void setControlAccessorFactory(ControlAccessorFactory controlAccessorFactory) {
        this.controlAccessorFactory = controlAccessorFactory;
    }

    public boolean isAutobinding() {
        return this.autobinding;
    }

    public void setAutobinding(boolean autobinding) {
        this.autobinding = autobinding;
    }

    @Override
    public BindingResult getBindingResult() {
        if (this.errors == null && this.getModel() != null) {
            this.createBindingResult();
        }
        return this.errors;
    }

    @Override
    public PropertyBinder getBinder(String propertyName) {
        return this.binder.getBinder(propertyName);
    }

    public boolean isInitializeControls() {
        return this.initializeControls;
    }

    public void setInitializeControls(boolean initializeControls) {
        this.initializeControls = initializeControls;
    }

    public ControlInitializer getControlInitializer() {
        return this.controlInitializer;
    }

    public void setControlInitializer(ControlInitializer controlInitializer) {
        this.controlInitializer = controlInitializer;
    }
}

