/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.db;

import info.joseluismartin.db.Database;
import info.joseluismartin.db.DbConnection;
import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.ViewDialog;
import info.joseluismartin.gui.bind.ConfigurableControlAccessorFactory;
import info.joseluismartin.gui.form.BoxFormBuilder;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.list.ListComboBoxModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbConnectionForm
extends AbstractView<DbConnection>
implements ActionListener {
    private JComboBox database = new JComboBox();
    private JTextField port = new JTextField();
    private JTextField host = new JTextField();
    private JTextField dbName = new JTextField();
    private JTextField user = new JTextField();
    private JPasswordField password = new JPasswordField();
    private JButton test;
    private JLabel testResult = new JLabel();

    public DbConnectionForm() {
        this(new DbConnection());
    }

    public DbConnectionForm(DbConnection dbConnection) {
        super(dbConnection);
    }

    public void init() {
        this.test = new JButton(this.getMessage("DbConnectionForm.test"));
        this.test.addActionListener(this);
        this.database.setModel(new ListComboBoxModel((List)Database.DATABASES));
        FormUtils.setBold(this.testResult);
        this.testResult.setHorizontalAlignment(0);
        this.testResult.setAlignmentX(0.5f);
        this.autobind();
    }

    @Override
    protected JComponent buildPanel() {
        BoxFormBuilder fb = new BoxFormBuilder(FormUtils.createTitledBorder(this.getMessage("DbConnectionForm.title")));
        fb.row();
        fb.startBox();
        fb.setFixedHeight(true);
        fb.row();
        fb.add(this.getMessage("DbConnectionForm.database"), this.database);
        fb.row();
        fb.add(this.getMessage("DbConnectionForm.host"), this.host);
        fb.row();
        fb.add(this.getMessage("DbConnectionForm.port"), this.port);
        fb.row();
        fb.add(this.getMessage("DbConnectionForm.dbName"), this.dbName);
        fb.row();
        fb.add(this.getMessage("DbConnectionForm.user"), this.user);
        fb.row();
        fb.add(this.getMessage("DbConnectionForm.password"), this.password);
        fb.endBox();
        fb.row();
        fb.startBox();
        fb.setFixedHeight(true);
        fb.row();
        fb.add(Box.createHorizontalGlue());
        fb.add(this.test);
        fb.add(Box.createHorizontalGlue());
        fb.endBox();
        fb.row();
        fb.add(this.testResult, Short.MAX_VALUE);
        fb.row(Short.MAX_VALUE);
        fb.add(Box.createVerticalGlue());
        return fb.getForm();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
        if (((DbConnection)this.getModel()).test()) {
            this.testResult.setText(this.getMessage("DbConnectionForm.success"));
            this.testResult.setForeground(new Color(0, 150, 0));
        } else {
            this.testResult.setText(this.getMessage("DbConnectionForm.failed"));
            this.testResult.setForeground(Color.RED);
        }
    }

    @Override
    public void doRefresh() {
        for (Database db : Database.DATABASES) {
            if (!db.equals(((DbConnection)this.getModel()).getDatabase())) continue;
            this.database.setSelectedItem(db);
        }
    }

    public static void main(String[] args) {
        ViewDialog<DbConnection> d = new ViewDialog<DbConnection>();
        DbConnectionForm dbf = new DbConnectionForm(new DbConnection());
        dbf.setControlAccessorFactory(new ConfigurableControlAccessorFactory());
        dbf.init();
        d.setView(dbf);
        d.init();
        d.setVisible(true);
    }
}

