/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.db;

import info.joseluismartin.db.Database;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbConnection {
    private static Log log = LogFactory.getLog(DbConnection.class);
    public static final String DRIVER = "jdbc.driverClassName";
    public static final String URL = "jdbc.url";
    public static final String USERNAME = "jdbc.username";
    public static final String PASSWORD = "jdbc.password";
    public static final String FILE_NAME = "jdbc.properties";
    private Database database;
    private String host;
    private String port;
    private String dbName;
    private String user;
    private String password;
    private String url;

    public boolean test() {
        boolean success = false;
        try {
            Class.forName(this.database.getDriver());
            String connectionUrl = this.buildUrl();
            Connection conn = DriverManager.getConnection(connectionUrl, this.user, this.password);
            conn.close();
            success = true;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return success;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String buildUrl() {
        if (StringUtils.isEmpty((String)this.port)) {
            this.port = this.database.getDefaultPort();
        }
        this.url = this.database.getName().equals("ORACLE") ? "jdbc:" + this.getDatabase().getJdbcName() + "://@" + this.getHost() + ":" + this.getPort() + ":" + this.getDbName() : "jdbc:" + this.getDatabase().getJdbcName() + "://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        try {
            String[] parts = url.split("//");
            String[] hpd = parts[1].split(":");
            if (hpd[0].startsWith("@")) {
                this.setHost(hpd[0].substring(1));
            } else {
                this.setHost(hpd[0]);
            }
            if (hpd.length == 3) {
                this.setPort(hpd[1]);
                this.setDbName(hpd[2]);
            } else {
                String[] pd = hpd[1].split("/");
                this.setPort(pd[0]);
                this.setDbName(pd[1]);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void setDriver(String driver) {
        if (this.database == null) {
            this.database = new Database();
        }
        this.database.setDriver(driver);
    }

    public String getDriver() {
        return this.database != null ? this.database.getDriver() : null;
    }

    public void fromProperties(Properties prop) {
        this.setUser(prop.getProperty(USERNAME));
        this.setPassword(prop.getProperty(PASSWORD));
        this.setUrl(prop.getProperty(URL));
        this.setDriver(prop.getProperty(DRIVER));
        for (Database db : Database.DATABASES) {
            if (!db.getDriver().equals(this.getDriver())) continue;
            this.setDatabase(db);
        }
    }

    public Properties toProperties() {
        Properties prop = new Properties();
        prop.put(DRIVER, this.getDatabase().getDriver());
        prop.put(URL, this.getUrl());
        prop.put(USERNAME, this.getUser());
        prop.put(PASSWORD, this.getPassword());
        return prop;
    }
}

