/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.validation;

import info.joseluismartin.gui.Binder;
import info.joseluismartin.gui.bind.PropertyBinder;
import info.joseluismartin.gui.validation.ErrorProcessor;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.FieldError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundErrorProcessor
implements ErrorProcessor {
    private Map<JComponent, Color> colorMap = new HashMap<JComponent, Color>();
    private Color errorColor = new Color(255, 130, 130);
    @Autowired
    private MessageSource messageSource;

    public void processError(Binder<?> binder, FieldError error) {
        if (binder instanceof PropertyBinder) {
            Object o = ((PropertyBinder)binder).getComponent();
            this.processError(o, error);
        }
    }

    @Override
    public void processError(Object control, FieldError error) {
        if (control instanceof JComponent) {
            JComponent c = (JComponent)control;
            this.colorMap.put(c, c.getBackground());
            c.setBackground(this.errorColor);
            if (this.messageSource != null) {
                c.setToolTipText(this.messageSource.getMessage((MessageSourceResolvable)error, null));
            }
        }
    }

    @Override
    public void reset() {
        for (JComponent c : this.colorMap.keySet()) {
            c.setBackground(this.colorMap.get(c));
            c.setToolTipText(null);
        }
        this.colorMap.clear();
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

