/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ListTreeNode
implements MutableTreeNode {
    private MutableTreeNode parent;
    private List children = new ArrayList();
    private Object userObject = null;

    public ListTreeNode(String name) {
        this.userObject = name;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (node == null || !node.equals(this.children.get(i))) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public void add(TreeNode node) {
        this.children.add(node);
    }

    public void remove(TreeNode node) {
        this.children.remove(node);
    }

    public String toString() {
        return this.userObject.toString();
    }

    public List getList() {
        return this.children;
    }

    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
    }

    public void remove(int index) {
        this.children.remove(index);
    }

    public void remove(MutableTreeNode node) {
        this.children.remove(node);
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
        this.parent.insert(this, newParent.getChildCount());
    }

    public void setUserObject(Object object) {
    }
}

