/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.table;

import info.joseluismartin.dao.Page;
import info.joseluismartin.dao.PageableDataSource;
import info.joseluismartin.gui.GuiFactory;
import info.joseluismartin.gui.PageableTable;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.report.ReportListView;
import info.joseluismartin.gui.table.AddAction;
import info.joseluismartin.gui.table.TablePanelAction;
import info.joseluismartin.reporting.ReportDataProvider;
import info.joseluismartin.service.PersistentService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePanel
extends JPanel
implements ReportDataProvider {
    private static final long serialVersionUID = 1L;
    private PersistentService<Object, Serializable> persistentService;
    private String editorName;
    private GuiFactory guiFactory;
    private String name;
    private PageableTable table;
    private View<Object> filterView;
    private ReportListView reportListView;
    private List<Action> actions = new ArrayList<Action>();

    public void init() {
        BorderLayout layout = new BorderLayout();
        layout.setVgap(10);
        layout.setHgap(10);
        this.setLayout(layout);
        this.add(this.createFilterBox(), "North");
        this.add(this.createTableBox(), "Center");
        if (this.filterView != null) {
            this.table.setFilter(this.filterView.getModel());
        }
        if (this.guiFactory != null) {
            this.table.setGuiFactory(this.guiFactory);
        }
        if (this.editorName != null) {
            this.table.setEditorName(this.editorName);
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F2"), "addAction");
        this.getActionMap().put("addAction", new AddAction());
    }

    private Component createReportListBox() {
        Box tableBox = Box.createHorizontalBox();
        tableBox.add(this.reportListView.getPanel());
        this.reportListView.setReportProvider(this);
        return tableBox;
    }

    private Component createTableBox() {
        Box tableBox = Box.createVerticalBox();
        tableBox.add(this.createControlBox());
        tableBox.add(Box.createVerticalStrut(5));
        this.table.setAlignmentX(0.0f);
        tableBox.add(this.table);
        return tableBox;
    }

    private Component createFilterBox() {
        Box header = Box.createVerticalBox();
        header.add(Box.createVerticalStrut(10));
        if (this.filterView != null) {
            this.filterView.refresh();
            header.add(this.filterView.getPanel());
        }
        header.setAlignmentX(0.0f);
        return header;
    }

    protected Box createControlBox() {
        Box controlBox = Box.createHorizontalBox();
        if (this.actions != null) {
            for (Action a : this.actions) {
                if (a instanceof TablePanelAction) {
                    ((TablePanelAction)a).setTablePanel(this);
                }
                JButton b = new JButton(a);
                controlBox.add(b);
                controlBox.add(Box.createHorizontalStrut(5));
            }
        }
        controlBox.add(Box.createHorizontalGlue());
        controlBox.setAlignmentX(0.0f);
        return controlBox;
    }

    public void refresh() {
        if (this.reportListView != null) {
            this.reportListView.refresh();
        }
        if (this.filterView != null) {
            this.filterView.refresh();
        }
        this.table.refresh();
    }

    public void selectAll() {
        PageableDataSource<Object> dataSource = this.table.getDataSource();
        Page page = new Page(Integer.MAX_VALUE);
        page.setFilter(this.filterView.getModel());
        this.table.getTableModel().check(dataSource.getKeys(page));
    }

    public PageableTable getTable() {
        return this.table;
    }

    public void setTable(PageableTable table) {
        this.table = table;
    }

    public View<Object> getFilterView() {
        return this.filterView;
    }

    public void setFilterView(View<Object> filterView) {
        this.filterView = filterView;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public PersistentService<Object, Serializable> getPersistentService() {
        return this.persistentService;
    }

    public void setPersistentService(PersistentService<Object, Serializable> ps) {
        this.persistentService = ps;
    }

    public JDialog getDialog() {
        JDialog dlg = this.guiFactory.getDialog(this.editorName);
        return dlg;
    }

    public JDialog getDialog(Object toEdit) {
        return (JDialog)this.guiFactory.getObject(this.editorName, new Object[]{toEdit});
    }

    public String getEditorName() {
        return this.editorName;
    }

    public void setEditorName(String editor) {
        this.editorName = editor;
    }

    public ReportListView getReportListView() {
        return this.reportListView;
    }

    public void setReportListView(ReportListView reportListView) {
        this.reportListView = reportListView;
    }

    public PersistentService<Object, Serializable> getDataSource() {
        return this.persistentService;
    }

    public Object getFilter() {
        return this.table.getFilter();
    }

    public String getSortProperty() {
        return this.table.getSortPropertyName();
    }

    public Page.Order getSortOrder() {
        return this.table.getOrder();
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public GuiFactory getGuiFactory() {
        return this.guiFactory;
    }

    public void setGuiFactory(GuiFactory guiFactory) {
        this.guiFactory = guiFactory;
    }
}

