/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.report;

import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.ApplicationContextGuiFactory;
import info.joseluismartin.gui.form.BoxFormBuilder;
import info.joseluismartin.gui.form.FormUtils;
import info.joseluismartin.gui.list.ListComboBoxModel;
import info.joseluismartin.gui.report.ReportFileView;
import info.joseluismartin.logic.PersistentManager;
import info.joseluismartin.reporting.Report;
import info.joseluismartin.reporting.ReportType;
import info.joseluismartin.service.ReportService;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportView
extends AbstractView<Report> {
    private JTextField name = new JTextField();
    private JComboBox comboType = FormUtils.newCombo(25);
    private ReportFileView fileView;
    private JTextArea description = new JTextArea();
    private PersistentManager<ReportType, Long> typeService;
    private ReportService reportService;

    public ReportView(Report model) {
        this.setModel(model);
    }

    public ReportView() {
        this(new Report());
    }

    public void init() {
        this.getPanel();
        this.refresh();
        this.bind(this.name, "name");
        this.bind(this.comboType, "type");
        this.bind(this.fileView.getFileName(), "fileName");
        this.bind(this.description, "description");
    }

    @Override
    protected void doRefresh() {
        if (this.getModel() == null) {
            return;
        }
        this.fileView.setModel(this.getModel());
        this.fileView.refresh();
        this.comboType.setSelectedItem(((Report)this.getModel()).getType());
    }

    @Override
    public void doUpdate() {
        if (this.getModel() == null) {
            return;
        }
        this.fileView.update();
    }

    @Override
    protected JComponent buildPanel() {
        Report model = (Report)this.getModel();
        BoxFormBuilder mainBox = new BoxFormBuilder();
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Nombre: "));
        box.add(this.name);
        box.add(Box.createHorizontalStrut(5));
        this.comboType.setModel(new ListComboBoxModel(this.typeService.getAll()));
        this.comboType.setSelectedItem(((Report)this.getModel()).getType());
        box.add(new JLabel("Tipo: "));
        box.add(this.comboType);
        mainBox.add(box);
        this.fileView.setModel(model);
        mainBox.add(this.fileView.getPanel());
        mainBox.row();
        mainBox.add(new JLabel("Descripci\u00c3\u00b3n"));
        mainBox.row();
        this.description.setRows(5);
        mainBox.add(new JScrollPane(this.description));
        mainBox.getForm().setOpaque(true);
        JComponent mainPanel = mainBox.getForm();
        mainPanel.setBorder(ApplicationContextGuiFactory.createTitledBorder("Informe"));
        return mainPanel;
    }

    @Override
    public void onSetModel(Report model) {
        if (this.reportService != null) {
            this.reportService.initialize((Object)model, 2);
        }
    }

    public ReportFileView getFileView() {
        return this.fileView;
    }

    public void setFileView(ReportFileView fileView) {
        this.fileView = fileView;
    }

    public PersistentManager<ReportType, Long> getTypeService() {
        return this.typeService;
    }

    public void setTypeService(PersistentManager<ReportType, Long> typeService) {
        this.typeService = typeService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }
}

