/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.form;

import info.joseluismartin.gui.bind.BinderFactory;
import info.joseluismartin.gui.form.FormFocusTransversalPolicy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.springframework.context.MessageSource;

public class BoxFormBuilder {
    private Box container = Box.createHorizontalBox();
    private List<Box> columns = new ArrayList<Box>();
    private List<Integer> columnsWidth = new ArrayList<Integer>();
    private List<Integer> columnsHeight = new ArrayList<Integer>();
    private int index = 0;
    private int rows = 0;
    private int height = 30;
    private int charWidth = 6;
    private boolean debug = false;
    private BinderFactory binderFactory;
    private MessageSource messageSource;
    private FormFocusTransversalPolicy focusTransversal = new FormFocusTransversalPolicy();

    public BoxFormBuilder() {
    }

    public BoxFormBuilder(BinderFactory binderFactory) {
        this.binderFactory = binderFactory;
    }

    public void add(Component c) {
        Box column = this.getColumn();
        if (!c.isMaximumSizeSet()) {
            c.setMaximumSize(new Dimension(Short.MAX_VALUE, this.height));
        }
        column.add(c);
        column.add(Box.createVerticalStrut(5));
        ++this.index;
        if (!(c instanceof JLabel)) {
            this.focusTransversal.add(c);
        }
    }

    private Box getColumn() {
        Box column = null;
        if (this.index < this.columns.size()) {
            column = this.columns.get(this.index);
        } else {
            column = Box.createVerticalBox();
            this.columns.add(column);
            this.container.add(column);
            this.container.add(Box.createHorizontalStrut(5));
            this.columnsHeight.add(0);
            this.columnsWidth.add(0);
            if (this.debug) {
                column.setBorder(BorderFactory.createLineBorder(Color.RED));
            }
        }
        return column;
    }

    public void add(String name, Component c) {
        JLabel label = new JLabel(name);
        this.add(label);
        this.setMaxWidth(name.length() * this.charWidth);
        this.add(c);
    }

    public void setMaxWidth(int i) {
        if (i > this.columnsWidth.get(this.index - 1)) {
            this.columnsWidth.set(this.index - 1, i);
        }
    }

    public void row() {
        this.index = 0;
        ++this.rows;
    }

    public JComponent getForm() {
        for (int i = 0; i < this.columns.size(); ++i) {
            Box box = this.columns.get(i);
            int maxWidth = this.columnsWidth.get(i) == 0 ? Short.MAX_VALUE : this.columnsWidth.get(i);
            int maxHeight = this.columnsHeight.get(i) == 0 ? (this.rows + 1) * this.height : this.columnsHeight.get(i);
            box.setMaximumSize(new Dimension(maxWidth, maxHeight));
        }
        this.container.setFocusTraversalPolicy(this.focusTransversal);
        this.container.setFocusTraversalPolicyProvider(true);
        return this.container;
    }

    public void reset() {
        this.columns = new ArrayList<Box>();
        this.columnsWidth = new ArrayList<Integer>();
        this.columnsHeight = new ArrayList<Integer>();
        this.container = Box.createHorizontalBox();
        this.index = 0;
        this.rows = 0;
        this.focusTransversal = new FormFocusTransversalPolicy();
    }

    public void next() {
        this.getColumn();
        ++this.index;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public BinderFactory getBinderFactory() {
        return this.binderFactory;
    }

    public void setBinderFactory(BinderFactory binderFactory) {
        this.binderFactory = binderFactory;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

