/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.bind.AbstractBinder;
import java.beans.PropertyEditor;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.JTextComponent;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.propertyeditors.CustomDateEditor;

public class TextComponentBinder
extends AbstractBinder {
    private PropertyEditorRegistry registry = new PropertyEditorRegistrySupport();

    public TextComponentBinder() {
        this.registry.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(SimpleDateFormat.getDateTimeInstance(), true));
    }

    public void doRefresh() {
        Object value = this.getValue();
        String text = this.getAsText(value);
        ((JTextComponent)this.component).setText(text);
    }

    private String getAsText(Object value) {
        String text = "";
        if (value != null) {
            PropertyEditor pe = this.registry.findCustomEditor(value.getClass(), null);
            if (pe != null) {
                pe.setValue(value);
                text = pe.getAsText();
            } else {
                text = value.toString();
            }
        }
        return text;
    }

    public void doUpdate() {
        String newValue = ((JTextComponent)this.component).getText();
        this.setValue(newValue.trim());
    }
}

