/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.bind.ControlError;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.ObjectError;

public class ControlBindingErrorProcessor
extends DefaultBindingErrorProcessor {
    public void processPropertyAccessException(Object control, PropertyAccessException ex, BindingResult bindingResult) {
        String field = ex.getPropertyName();
        String[] codes = bindingResult.resolveMessageCodes(ex.getErrorCode(), field);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), field);
        Object rejectedValue = ex.getValue();
        if (rejectedValue != null && rejectedValue.getClass().isArray()) {
            rejectedValue = StringUtils.arrayToCommaDelimitedString((Object[])ObjectUtils.toObjectArray((Object)rejectedValue));
        }
        bindingResult.addError((ObjectError)new ControlError(control, bindingResult.getObjectName(), field, rejectedValue, true, codes, arguments, ex.getLocalizedMessage()));
    }
}

