/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.Selector;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.bind.ComboAccessor;
import info.joseluismartin.gui.bind.ControlAccessor;
import info.joseluismartin.gui.bind.ControlAccessorFactory;
import info.joseluismartin.gui.bind.ListAccessor;
import info.joseluismartin.gui.bind.SelectorAccessor;
import info.joseluismartin.gui.bind.TextComponentAccessor;
import info.joseluismartin.gui.bind.ToggleButtonAccessor;
import info.joseluismartin.gui.bind.ViewAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableControlAccessorFactory
implements ControlAccessorFactory {
    private static final Log log = LogFactory.getLog(ConfigurableControlAccessorFactory.class);
    private static ControlAccessorFactory defaultFactory;
    private Map<Class<?>, Class<? extends ControlAccessor>> accessors = new Hashtable();
    private boolean mergeAccessors = true;

    public ConfigurableControlAccessorFactory() {
        this.initDefaultAccessors();
    }

    @Override
    public ControlAccessor getControlAccessor(Object control) {
        Class<? extends ControlAccessor> accessorClass = null;
        ControlAccessor accessor = null;
        Class<?> clazz = control.getClass();
        accessorClass = this.accessors.get(clazz);
        if (accessorClass == null) {
            List superclasses = ClassUtils.getAllSuperclasses(clazz);
            superclasses.addAll(ClassUtils.getAllInterfaces(clazz));
            Iterator iter = superclasses.iterator();
            while (iter.hasNext() && accessorClass == null) {
                accessorClass = this.accessors.get(iter.next());
            }
        }
        if (accessorClass != null) {
            try {
                Constructor<? extends ControlAccessor> ctor = accessorClass.getConstructor(Object.class);
                accessor = ctor.newInstance(control);
            }
            catch (InstantiationException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
            catch (SecurityException e) {
                log.error((Object)e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)e);
            }
        } else {
            log.warn((Object)("Can't find a accessor for class: " + clazz.getName()));
        }
        return accessor;
    }

    private void initDefaultAccessors() {
        this.accessors.put(JTextComponent.class, TextComponentAccessor.class);
        this.accessors.put(JList.class, ListAccessor.class);
        this.accessors.put(Selector.class, SelectorAccessor.class);
        this.accessors.put(JToggleButton.class, ToggleButtonAccessor.class);
        this.accessors.put(JComboBox.class, ComboAccessor.class);
        this.accessors.put(View.class, ViewAccessor.class);
    }

    public static synchronized ControlAccessorFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = new ConfigurableControlAccessorFactory();
        }
        return defaultFactory;
    }

    public Map<Class<?>, Class<? extends ControlAccessor>> getAccessors() {
        return this.accessors;
    }

    public void setAccessors(Map<Class<?>, Class<? extends ControlAccessor>> accessors) {
        if (!this.mergeAccessors) {
            this.accessors.clear();
        }
        this.accessors.putAll(accessors);
    }

    public boolean isMergeAccessors() {
        return this.mergeAccessors;
    }

    public void setMergeAccessors(boolean mergeAccessors) {
        this.mergeAccessors = mergeAccessors;
    }
}

