/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.beans.PropertyUtils;
import info.joseluismartin.gui.Binder;
import info.joseluismartin.gui.bind.BinderFactory;
import info.joseluismartin.gui.bind.BinderHolder;
import info.joseluismartin.gui.bind.PropertyBinder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBinder<T>
implements Binder<T>,
BinderHolder {
    private BinderFactory binderFactory;
    private Map<String, Binder<T>> binders = new HashMap<String, Binder<T>>();
    private T model;
    private BindingResult bindingResult;

    public CompositeBinder() {
    }

    public CompositeBinder(T model) {
        this.model = model;
    }

    public void bind(Object component, String propertyName) {
        this.bind(component, propertyName, false);
    }

    public void bind(Object component, String propertyName, boolean readOnly) {
        this.bind(component, propertyName, this.getModel(), readOnly);
    }

    public void bind(Object component, String propertyName, T model, boolean readOnly) {
        PropertyBinder binder = this.binderFactory.getBinder(component.getClass());
        if (binder != null) {
            binder.bind(component, propertyName, model, readOnly);
            this.binders.put(propertyName, binder);
        }
    }

    @Override
    public void refresh() {
        for (Binder<T> b : this.binders.values()) {
            b.refresh();
        }
    }

    public void addBinder(Binder<?> binder, String name) {
        this.binders.put(name, binder);
    }

    @Override
    public void update() {
        this.bindingResult = null;
        for (Binder<T> b : this.binders.values()) {
            b.update();
        }
    }

    @Override
    public PropertyBinder getBinder(String propertyName) {
        if (PropertyUtils.isNested((String)propertyName)) {
            BinderHolder binderHolder = (BinderHolder)((Object)this.binders.get(PropertyUtils.getFirstPropertyName((String)propertyName)));
            return binderHolder != null ? binderHolder.getBinder(PropertyUtils.getNestedPath((String)propertyName)) : null;
        }
        return (PropertyBinder)this.binders.get(propertyName);
    }

    public Set<String> getPropertyNames() {
        return this.binders.keySet();
    }

    public Collection<Binder<T>> getPropertyBinders() {
        return this.binders.values();
    }

    public BinderFactory getBinderFactory() {
        return this.binderFactory;
    }

    public void setBinderFactory(BinderFactory binderFactory) {
        this.binderFactory = binderFactory;
    }

    @Override
    public T getModel() {
        return this.model;
    }

    @Override
    public void setModel(T model) {
        this.model = model;
        for (Binder<T> b : this.binders.values()) {
            b.setModel(model);
        }
    }

    @Override
    public BindingResult getBindingResult() {
        if (this.getModel() == null) {
            return null;
        }
        if (this.bindingResult == null) {
            this.createBindingResult();
            for (Binder<T> b : this.binders.values()) {
                if (b.getBindingResult() == null || !this.bindingResult.getObjectName().equals(b.getBindingResult().getObjectName())) continue;
                this.bindingResult.addAllErrors((Errors)b.getBindingResult());
            }
        }
        return this.bindingResult;
    }

    private void createBindingResult() {
        this.bindingResult = new BeanPropertyBindingResult(this.getModel(), this.getModel().getClass().getSimpleName());
    }
}

