/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.View;
import info.joseluismartin.gui.bind.ControlAccessor;
import info.joseluismartin.gui.bind.ControlChangeListener;
import info.joseluismartin.gui.bind.ControlEvent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControlAccessor
implements ControlAccessor {
    private Object control;
    private List<ControlChangeListener> listeners = new ArrayList<ControlChangeListener>();
    private TypeConverter converter = new SimpleTypeConverter();

    public AbstractControlAccessor() {
    }

    public AbstractControlAccessor(Object control) {
        this.setControl(control);
    }

    @Override
    public void addControlChangeListener(ControlChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeControlChangeListener(ControlChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    protected <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return (T)this.converter.convertIfNecessary(value, requiredType);
    }

    protected void fireControlChange() {
        for (ControlChangeListener l : this.listeners) {
            l.controlChange(new ControlEvent(this));
        }
    }

    public Object getControl() {
        return this.control;
    }

    public void setControl(Object control) {
        this.control = control;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.control instanceof Component) {
            ((Component)this.control).setEnabled(enabled);
        } else if (this.control instanceof View) {
            ((View)this.control).enableView(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.control instanceof Component) {
            return ((Component)this.control).isEnabled();
        }
        return true;
    }
}

