/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui.bind;

import info.joseluismartin.gui.ModelHolder;
import info.joseluismartin.gui.bind.ControlBindingErrorProcessor;
import info.joseluismartin.gui.bind.PropertyBinder;
import java.beans.PropertyEditor;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;

public abstract class AbstractBinder
implements PropertyBinder {
    private static final Log log = LogFactory.getLog(AbstractBinder.class);
    protected String propertyName;
    protected Object oldValue;
    private Object model;
    protected Object component;
    protected boolean readOnly = false;
    private ControlBindingErrorProcessor errorProcessor = new ControlBindingErrorProcessor();
    private BindingResult bindingResult;

    public final void bind(Object component, String propertyName, Object model) {
        this.bind(component, propertyName, model, false);
    }

    public final void bind(Object component, String propertyName, Object model, boolean readOnly) {
        this.propertyName = propertyName;
        this.model = model;
        this.component = component;
        this.readOnly = readOnly;
        this.doBind();
    }

    protected void doBind() {
    }

    public final void refresh() {
        this.doRefresh();
    }

    public final void update() {
        if (!this.readOnly && this.model != null) {
            this.bindingResult = this.createBindingResult();
            this.doUpdate();
        }
    }

    protected BindingResult createBindingResult() {
        return new BeanPropertyBindingResult(this.model, this.model.getClass().getSimpleName());
    }

    protected abstract void doRefresh();

    protected abstract void doUpdate();

    protected void setValue(Object value) {
        if (value == null || value != this.oldValue) {
            BeanWrapper wrapper = this.getBeanWrapper();
            try {
                wrapper.setPropertyValue(this.propertyName, value);
                this.oldValue = value;
            }
            catch (PropertyAccessException pae) {
                log.error((Object)pae);
                this.errorProcessor.processPropertyAccessException(this.component, pae, this.bindingResult);
            }
        }
    }

    protected Object getValue() {
        BeanWrapper wrapper = this.getBeanWrapper();
        Object value = null;
        try {
            value = wrapper.getPropertyValue(this.propertyName);
        }
        catch (BeansException e) {
            log.error((Object)e);
        }
        return value;
    }

    private BeanWrapper getBeanWrapper() {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.getModel());
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(SimpleDateFormat.getDateTimeInstance(), true));
        return wrapper;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    protected Object getOldValue() {
        return this.oldValue;
    }

    protected void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getModel() {
        if (this.model instanceof ModelHolder) {
            return ((ModelHolder)this.model).getModel();
        }
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public Object getComponent() {
        return this.component;
    }

    public void setComponent(Object component) {
        this.component = component;
    }

    public BindingResult getBindingResult() {
        return this.bindingResult;
    }
}

