/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.Editor;
import info.joseluismartin.gui.EditorEvent;
import info.joseluismartin.gui.EditorListener;
import info.joseluismartin.gui.View;
import info.joseluismartin.gui.action.DialogCancelAction;
import info.joseluismartin.gui.action.ViewAction;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.springframework.validation.BindingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewFrame
extends JFrame
implements View<Object>,
Editor {
    private static final long serialVersionUID = 1L;
    private View<Object> view;
    private ViewAction acceptAction;
    private DialogCancelAction cancelAction;
    private JButton acceptButton;
    private JButton cancelButton;
    private int windowWidth;
    private int windowHeight;
    private EventListenerList listenerList = new EventListenerList();

    public void init() {
        this.add((Component)this.view.getPanel(), "Center");
        this.add(this.createButtonBox(), "South");
        this.setTitle(this.view.getModel().toString());
        this.setLocationRelativeTo(null);
        this.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.pack();
    }

    protected Component createButtonBox() {
        this.acceptButton = new JButton(this.acceptAction);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel p = new JPanel();
        p.add(this.acceptButton);
        p.add(this.cancelButton);
        return p;
    }

    @Override
    public void save() {
        Object[] listeners = this.listenerList.getListenerList();
        EditorEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (e == null) {
                e = new EditorEvent(this, this.getModel());
            }
            ((EditorListener)listeners[i + 1]).modelChanged(e);
        }
    }

    public View<Object> getView() {
        return this.view;
    }

    public void setView(View<Object> view) {
        this.view = view;
    }

    public ViewAction getAcceptAction() {
        return this.acceptAction;
    }

    public void setAcceptAction(ViewAction acceptAction) {
        this.acceptAction = acceptAction;
        this.acceptAction.setView(this.view);
        this.acceptAction.setDialog(this);
    }

    public DialogCancelAction getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(DialogCancelAction cancelAction) {
        this.cancelAction = cancelAction;
        cancelAction.setDialog(this);
    }

    @Override
    public Object getModel() {
        return this.view.getModel();
    }

    @Override
    public JComponent getPanel() {
        return this.view.getPanel();
    }

    @Override
    public void refresh() {
        this.view.refresh();
        this.setTitle(this.view.getModel().toString());
    }

    @Override
    public void setModel(Object model) {
        this.view.setModel(model);
    }

    @Override
    public void update() {
        this.view.update();
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public boolean validateView() {
        return this.view.validateView();
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    @Override
    public void addEditorListener(EditorListener l) {
        this.listenerList.add(EditorListener.class, l);
    }

    public void removeEditorListener(EditorListener l) {
        this.listenerList.remove(EditorListener.class, l);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void setClean() {
    }

    @Override
    public void setDirty() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void enableView(boolean enabled) {
        this.view.enableView(enabled);
        this.acceptButton.setEnabled(enabled);
    }

    @Override
    public BindingResult getBindingResult() {
        return this.view.getBindingResult();
    }

    @Override
    public String getErrorMessage() {
        return this.view.getErrorMessage();
    }
}

