/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.View;
import info.joseluismartin.gui.action.DialogAcceptAction;
import info.joseluismartin.gui.action.DialogCancelAction;
import info.joseluismartin.gui.action.ViewAction;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.springframework.validation.BindingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDialog<T>
extends JDialog
implements View<T> {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static final long serialVersionUID = 1L;
    private View<T> view;
    private ViewAction acceptAction = new DialogAcceptAction();
    private DialogCancelAction cancelAction = new DialogCancelAction();
    private JButton acceptButton;
    private JButton cancelButton;
    private int dialogWidth = 750;
    private int dialogHeight = 750;
    private int value = 1;

    public ViewDialog() {
        this.acceptAction.setDialog(this);
        this.cancelAction.setDialog(this);
    }

    public void init() {
        this.acceptAction.setView(this.view);
        this.add((Component)this.view.getPanel(), "Center");
        if (this.view.getModel() != null) {
            this.setTitle(this.view.getModel().toString());
        }
        this.add(this.createButtonBox(), "South");
        this.setSize(this.dialogWidth, this.dialogHeight);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    protected Component createButtonBox() {
        this.acceptButton = new JButton(this.acceptAction);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel p = new JPanel();
        p.add(this.acceptButton);
        p.add(this.cancelButton);
        return p;
    }

    public View<T> getView() {
        return this.view;
    }

    public void setView(View<T> view) {
        this.view = view;
    }

    public ViewAction getAcceptAction() {
        return this.acceptAction;
    }

    public void setAcceptAction(ViewAction acceptAction) {
        this.acceptAction = acceptAction;
        this.acceptAction.setView(this.view);
        this.acceptAction.setDialog(this);
    }

    public DialogCancelAction getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(DialogCancelAction cancelAction) {
        this.cancelAction = cancelAction;
        cancelAction.setDialog(this);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getDialogWidth() {
        return this.dialogWidth;
    }

    public void setDialogWidth(int dialogWidth) {
        this.dialogWidth = dialogWidth;
    }

    public int getDialogHeight() {
        return this.dialogHeight;
    }

    public void setDialogHeight(int dialogHeight) {
        this.dialogHeight = dialogHeight;
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public T getModel() {
        return this.view.getModel();
    }

    @Override
    public JComponent getPanel() {
        return this.view.getPanel();
    }

    @Override
    public void refresh() {
        if (this.view.getModel() != null) {
            this.setTitle(this.view.getModel().toString());
        }
        this.view.refresh();
    }

    @Override
    public void setModel(T model) {
        this.view.setModel(model);
    }

    @Override
    public void update() {
        this.view.update();
    }

    @Override
    public boolean validateView() {
        return this.view.validateView();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void enableView(boolean enabled) {
        this.view.enableView(enabled);
        this.acceptButton.setEnabled(enabled);
    }

    @Override
    public BindingResult getBindingResult() {
        return this.view.getBindingResult();
    }

    @Override
    public String getErrorMessage() {
        return this.view.getErrorMessage();
    }
}

