/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.gui.form.BoxFormBuilder;
import info.joseluismartin.gui.list.ListListModel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String name;
    private ListListModel available = new ListListModel();
    private ListListModel selected = new ListListModel();
    private List<T> all = new ArrayList<T>();
    private JList availableList;
    private JList selectedList;
    private JButton addSelectedButton;
    private JButton removeSelectedButton;
    private Icon rightArrow;
    private Icon leftArrow;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean firingActionEvent = false;

    public Selector() {
    }

    public Selector(List<T> all) {
        this(all, new ArrayList());
        this.all = all;
    }

    public Selector(List<T> available, List<T> selected) {
        this.available = new ListListModel(available);
        this.selected = new ListListModel(selected);
        this.all.addAll(available);
        this.all.addAll(selected);
    }

    public void init() {
        this.setLayout(new BoxLayout(this, 2));
        this.availableList = new JList(this.available);
        this.selectedList = new JList(this.selected);
        if (this.rightArrow == null) {
            this.rightArrow = new ImageIcon(this.getClass().getResource("/images/button_right.png"));
        }
        if (this.leftArrow == null) {
            this.leftArrow = new ImageIcon(this.getClass().getResource("/images/button_left.png"));
        }
        this.addSelectedButton = new JButton(new AddSelectedAction());
        this.removeSelectedButton = new JButton(new RemoveSelectedAction());
        JLabel availableLabel = new JLabel("Disponibles");
        JLabel selectedLabel = new JLabel("Asignadas");
        JScrollPane availableScroll = new JScrollPane(this.availableList);
        JScrollPane selectedScroll = new JScrollPane(this.selectedList);
        this.availableList.setVisibleRowCount(3);
        this.selectedList.setVisibleRowCount(3);
        BoxFormBuilder b = new BoxFormBuilder();
        b.add(availableLabel);
        b.next();
        b.add(selectedLabel);
        b.row();
        b.add(availableScroll);
        Box arrowBox = Box.createHorizontalBox();
        this.removeSelectedButton.setAlignmentX(0.5f);
        this.addSelectedButton.setAlignmentX(0.5f);
        arrowBox.add(this.removeSelectedButton);
        arrowBox.add(Box.createHorizontalStrut(5));
        arrowBox.add(this.addSelectedButton);
        b.add(arrowBox);
        arrowBox.setAlignmentY(0.5f);
        arrowBox.setAlignmentX(0.5f);
        arrowBox.setMaximumSize(new Dimension(70, 30));
        b.add(selectedScroll);
        Box box = (Box)b.getForm();
        box.getComponent(0).setMaximumSize(new Dimension(300, 200));
        box.getComponent(2).setMaximumSize(new Dimension(70, 30));
        box.getComponent(4).setMaximumSize(new Dimension(300, 200));
        box.setMaximumSize(new Dimension(400, 200));
        this.add(Box.createHorizontalGlue());
        this.add(box);
        this.add(Box.createHorizontalGlue());
        availableScroll.setMaximumSize(new Dimension(300, 200));
        availableScroll.setPreferredSize(new Dimension(300, 100));
        availableScroll.setAlignmentX(1.0f);
        availableLabel.setAlignmentX(1.0f);
        selectedScroll.setMaximumSize(new Dimension(300, 200));
        selectedScroll.setPreferredSize(new Dimension(300, 100));
        selectedScroll.setAlignmentX(0.0f);
        selectedLabel.setAlignmentX(0.0f);
    }

    private void addSelected() {
        Object[] selectedValues = this.availableList.getSelectedValues();
        if (selectedValues.length > 0) {
            ListListModel availableModel = (ListListModel)this.availableList.getModel();
            availableModel.removeAll(Arrays.asList(selectedValues));
            ListListModel selectedModel = (ListListModel)this.selectedList.getModel();
            selectedModel.addAll(Arrays.asList(selectedValues));
            this.clearSelections();
            this.fireActionEvent();
        }
    }

    private void clearSelections() {
        this.availableList.clearSelection();
        this.selectedList.clearSelection();
    }

    private void removeSelected() {
        Object[] selectedValues = this.selectedList.getSelectedValues();
        if (selectedValues.length > 0) {
            ListListModel selectedModel = (ListListModel)this.selectedList.getModel();
            selectedModel.removeAll(Arrays.asList(selectedValues));
            ListListModel availableModel = (ListListModel)this.availableList.getModel();
            availableModel.addAll(Arrays.asList(selectedValues));
            this.clearSelections();
            this.fireActionEvent();
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent event = new ActionEvent(this, 1001, "selectorChanged");
            for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
                listener.actionPerformed(event);
            }
            this.firingActionEvent = false;
        }
    }

    public List<T> getAvailable() {
        return this.available.getList();
    }

    public void setAvailable(List<T> available) {
        this.available.clear();
        this.available.addAll(available);
        ArrayList<T> l = new ArrayList<T>(this.all);
        l.removeAll(available);
        this.selected.clear();
        this.selected.addAll(l);
    }

    public List<T> getSelected() {
        return this.selected.getList();
    }

    public void setSelected(List<T> selected) {
        this.selected.clear();
        this.selected.addAll(selected);
        this.available.clear();
        this.available.addAll(this.all);
        this.available.removeAll(selected);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Icon getRightArrow() {
        return this.rightArrow;
    }

    public void setRightArrow(Icon rightArrow) {
        this.rightArrow = rightArrow;
    }

    public Icon getLeftArrow() {
        return this.leftArrow;
    }

    public void setLeftArrow(Icon leftArrow) {
        this.leftArrow = leftArrow;
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListner(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public List<T> getAll() {
        return this.all;
    }

    public void setAll(List<T> all) {
        this.all = all;
    }

    private class RemoveSelectedAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RemoveSelectedAction() {
            this.putValue("SmallIcon", Selector.this.leftArrow);
        }

        public void actionPerformed(ActionEvent e) {
            Selector.this.removeSelected();
        }
    }

    private class AddSelectedAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddSelectedAction() {
            this.putValue("SmallIcon", Selector.this.rightArrow);
        }

        public void actionPerformed(ActionEvent e) {
            Selector.this.addSelected();
        }
    }
}

