/*
 * Decompiled with CFR 0.152.
 */
package info.joseluismartin.gui;

import info.joseluismartin.dao.PageChangedEvent;
import info.joseluismartin.dao.Paginator;
import info.joseluismartin.dao.PaginatorListener;
import info.joseluismartin.gui.AbstractView;
import info.joseluismartin.gui.DefaultPaginator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatorView
extends AbstractView<Paginator>
implements PaginatorListener {
    private Paginator paginator;
    private JComboBox pageSizeCombo;
    private JButton nextPageButton;
    private JButton previousPageButton;
    private JButton lastPageButton;
    private JButton firstPageButton;
    private String[] pageSizes;
    private JLabel statusLabel;
    private JLabel countLabel;
    private MessageSource messageSource = new ResourceBundleMessageSource();
    private Image nextIcon;
    private Image previousIcon;
    private Image lastIcon;
    private Image firstIcon;

    public PaginatorView() {
        this(new DefaultPaginator());
    }

    public PaginatorView(Paginator paginator) {
        this.paginator = paginator;
        paginator.addPaginatorListener((PaginatorListener)this);
    }

    public void init() {
    }

    @Override
    protected JComponent buildPanel() {
        this.pageSizeCombo = new JComboBox<String>(this.pageSizes);
        this.pageSizeCombo.addItemListener(new PageSizeComboListener());
        this.nextPageButton = new JButton(new NextPageAction());
        this.previousPageButton = new JButton(new PreviousPageAction());
        this.lastPageButton = new JButton(new LastPageAction());
        this.firstPageButton = new JButton(new FirstPageAction());
        this.statusLabel = new JLabel();
        this.countLabel = new JLabel();
        JLabel numberPagesLabel = new JLabel("Page Size: ");
        this.pageSizeCombo.setMaximumSize(new Dimension(70, 30));
        numberPagesLabel.setAlignmentX(1.0f);
        Box box = Box.createHorizontalBox();
        box.setBackground(Color.LIGHT_GRAY);
        box.setOpaque(true);
        box.add(this.countLabel);
        box.add(Box.createHorizontalStrut(100));
        box.add(Box.createHorizontalGlue());
        box.add(this.firstPageButton);
        box.add(this.previousPageButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.statusLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.nextPageButton);
        box.add(this.lastPageButton);
        box.add(Box.createHorizontalGlue());
        box.add(numberPagesLabel);
        box.add(this.pageSizeCombo);
        box.add(Box.createHorizontalStrut(30));
        String pageSize = (String)this.pageSizeCombo.getSelectedItem();
        this.paginator.setPageSize(this.parsePageSize(pageSize));
        return box;
    }

    public void pageChanged(PageChangedEvent event) {
        this.refresh();
    }

    @Override
    public void doRefresh() {
        this.statusLabel.setText("" + this.paginator.getPage() + " / " + this.paginator.getTotalPages());
        this.countLabel.setText(this.messageSource.getMessage("PaginatorView.records", null, "Records: ", Locale.getDefault()) + this.paginator.getCount());
        boolean hasNext = this.paginator.hasNext();
        boolean hasPrevious = this.paginator.hasPrevious();
        this.nextPageButton.setEnabled(hasNext);
        this.lastPageButton.setEnabled(hasNext);
        this.previousPageButton.setEnabled(hasPrevious);
        this.firstPageButton.setEnabled(hasPrevious);
        this.pageSizeCombo.setSelectedItem(String.valueOf(this.paginator.getPageSize()));
    }

    @Override
    public void doUpdate() {
        this.paginator.setPageSize(this.parsePageSize((String)this.pageSizeCombo.getSelectedItem()));
    }

    public Image getNextIcon() {
        return this.nextIcon;
    }

    public void setNextIcon(Image nextIcon) {
        this.nextIcon = nextIcon;
    }

    public Image getPreviousIcon() {
        return this.previousIcon;
    }

    public void setPreviousIcon(Image previousIcon) {
        this.previousIcon = previousIcon;
    }

    public Image getLastIcon() {
        return this.lastIcon;
    }

    public void setLastIcon(Image lastIcon) {
        this.lastIcon = lastIcon;
    }

    public Image getFirstIcon() {
        return this.firstIcon;
    }

    public void setFirstIcon(Image firstIcon) {
        this.firstIcon = firstIcon;
    }

    public String[] getPageSizes() {
        return this.pageSizes;
    }

    public void setPageSizes(String[] pageSizes) {
        this.pageSizes = pageSizes;
    }

    public Paginator getPaginator() {
        return this.paginator;
    }

    public void setPaginator(Paginator paginator) {
        if (paginator != null) {
            paginator.removePaginatorListener((PaginatorListener)this);
        }
        this.paginator = paginator;
        paginator.addPaginatorListener((PaginatorListener)this);
    }

    private int parsePageSize(String item) {
        int pageSize;
        try {
            pageSize = Integer.parseInt(item.trim());
        }
        catch (NumberFormatException nfe) {
            pageSize = Short.MAX_VALUE;
        }
        return pageSize;
    }

    class PageSizeComboListener
    implements ItemListener {
        PageSizeComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            String item = (String)e.getItem();
            int pageSize = PaginatorView.this.parsePageSize(item);
            if (PaginatorView.this.paginator.getPageSize() != pageSize) {
                PaginatorView.this.paginator.setPageSize(pageSize);
            }
        }
    }

    class FirstPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FirstPageAction() {
            this.putValue("SmallIcon", new ImageIcon(PaginatorView.this.firstIcon));
        }

        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.firstPage();
        }
    }

    class LastPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LastPageAction() {
            this.putValue("SmallIcon", new ImageIcon(PaginatorView.this.lastIcon));
        }

        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.lastPage();
        }
    }

    class PreviousPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public PreviousPageAction() {
            this.putValue("SmallIcon", new ImageIcon(PaginatorView.this.previousIcon));
        }

        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.previousPage();
        }
    }

    class NextPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NextPageAction() {
            this.putValue("SmallIcon", new ImageIcon(PaginatorView.this.nextIcon));
        }

        public void actionPerformed(ActionEvent e) {
            PaginatorView.this.paginator.nextPage();
        }
    }
}

